# A survey of heavy-heavy hadronic molecules

Xiang-Kun Dong $^ { 1 , 2 }$ ,∗ Feng-Kun Guo $^ { 1 , 2 }$ ,† and Bing-Song Zou1,2,3‡ $^ { 1 }$ CAS Key Laboratory of Theoretical Physics, Institute of Theoretical Physics, Chinese Academy of Sciences, Beijing 100190, China $^ 2$ School of Physical Sciences, University of Chinese Academy of Sciences, Beijing 100049, China $^ 3$ School of Physics, Central South University, Changsha 410083, China

The spectrum of hadronic molecules composed of heavy-antiheavy charmed hadrons has been obtained in our previous work. The potentials are constants at the leading order, which are estimated from resonance saturation. The experimental candidates of hadronic molecules, say $X ( 3 8 7 2 )$ , $Y ( 4 2 6 0 )$ , three $P _ { c }$ states and $P _ { c s } ( 4 4 5 9 )$ , fit the spectrum well. The success in describing the pattern of heavy-antiheavy hadronic molecules stimulates us to give more predictions for the heavy-heavy cases, which are less discussed in literature than the heavy-antiheavy ones. Given that the heavyantiheavy hadronic molecules, several of which have strong experimental evidence, emerge from the dominant constant interaction from resonance saturation, we find that the existence of many heavyheavy hadronic molecules is natural. Among these predicted heavy-heavy states we highlight the $D D ^ { * }$ molecule and the $D ^ { ( * ) } \Sigma _ { c } ^ { ( * ) }$ molecules, which are the partners of the famous $X ( 3 8 7 2 )$ and $P _ { c }$ states. Quite recently, LHCb collaboration reported a doubly charmed tetraquark state, $T _ { c c }$ , which is in line with our results for the $D D ^ { * }$ molecule. With the first experimental signal of this new kind of exotic states, the upcoming update of the LHCb experiment as well as other experiments will provide more chances of observing the heavy-heavy hadronic molecules.

# I. INTRODUCTION

The fact that quantum chromodynamics (QCD) is nonperturbative at low energy makes the calculation of the whole hadron spectrum from first-principle too difficult at the present stage. The quark model proposed in Refs. [1, 2] successfully classify plenty of hadrons and its later developments after the birth of QCD (see, e.g., Refs. [3, 4]) provide a remarkable description of the hadron spectrum of $q q$ mesons and qqq baryons. However, there was little clear evidence for the multiquark states predicted in Ref. [1] until the discovery of the $X ( 3 8 7 2 )$ [5], also known as $\chi _ { c 1 } ( 3 8 7 2 )$ in the Review of Particle Physics (RPP) [6]. Since then many near-threshold structures, e.g. the $Z _ { c } ( 3 9 0 0 ) ^ { \pm }$ [7–9], the $Z _ { c } ( 4 0 2 0 ) ^ { \pm }$ [10, 11], the $Z _ { b } ( 1 0 6 1 0 / 1 0 6 5 0 ) ^ { \pm }$ [12, 13], the $Z _ { c s } ( 3 9 8 5 ) ^ { - }$ [14] and the $P _ { c }$ states [15], have been observed in the worldwide high energy experiments. These so-called exotic states are clearly outside the scope of the traditional quark model consisting of $q q$ mesons and qqq baryons but their inner structures are still under debate (see Refs. [16–32] for recent reviews of the multiquark states).

One peculiar and thus important property of these exotic states mentioned above is that they are all located quite close to the thresholds of a pair of hadrons that they can couple to. Therefore it is natural to consider them as hadronic molecules1 composed of the corresponding hadron pairs and such an idea was widely explored in the literature, see Ref. [21] for a review of hadronic molecules and Ref. [38] for a discussion of the general behaviors of near-threshold structures. Although many works have used different methods to explain certain properties of these near-threshold states, a whole and systematic spectrum of hadronic molecules will deepen our understanding of these exotic states. In Ref. [32], we have provided such a spectrum for heavy-antiheavy (taking charmed hadrons for example) hadronic molecules by solving the single channel Bethe-Salpeter (BS) equation with constant interactions, which are assumed to be vector mesonexchange saturated. In this work we extend the work in Ref. [32] to the heavy-heavy systems to make the spectrum more complete.

Note that all the experimentally established exotic states mentioned above are hidden-charm or hiddenbottom ones. It is much more difficult to produce the states with doubly heavy quarks than those with heavyantiheavy quarks since that require at least two heavy quark-antiquark pairs to be produced and two heavy (anti)quarks to move in a particular phase space region. It is only until very recently that the first experimental evidence for a double-charm tetraquark state was reported [39, 40], which immediately stimulated a series of theoretical studies [41–54]. Despite that, many attempts have been made to investigate the possible states with doubly heavy quarks, see the discussions in Sec. IV. On the one hand, the heavy antiquark–diquark symmetry for antiheavy baryons may lead to the corresponding doubly-heavy tetraquark states. On the other hand, like the heavy-antiheavy systems, the heavy-heavy hadronic molecules are also expected to exist.

This work is organized as follows. In Sec. II, we give a brief summary of the interactions between heavy hadrons following the heavy quark spin symmetry. In Sec. III, the potentials resulting from these interactions are presented and the molecular states obtained by solving the single channel BS equation are listed. Some selected states are discussed in Sec. IV, together with an incomplete review on the status of such systems in the literature. We then close this paper with a brief summary in Sec. V.

# II. LAGRANGIAN FROM HEAVY QUARK SPIN SYMMETRY

The interactions between hadrons consisting of one or more heavy quarks, say $c$ and $b$ due to their much larger masses than the typical QCD scale, can be constructed systematically under the guidance of heavy quark symmetries2 and such Lagrangians can be found in, e.g. Refs. [62–70]. The relevant Lagrangians and some details have been collected in our previous work [32] and here we will just give the final results that are needed. Note that in the following we are interested in the potential near threshold and will not consider coupled channels. Therefore, we only consider the coupling between heavy hadrons and light vector mesons and omit the Lagrangian that results in potentials proportional to the square of transferred momentum, $q ^ { 2 }$ .

# A. Coupling of light vector mesons and heavy mesons

The coupling of heavy mesons and light vector mesons can be introduced by using the hidden local symmetry approach [71? , 72] and the leading order Lagrangian is expressed as [32, 64, 69]

$$
\begin{array} { r l } & { \bar { C } _ { P P V } = - \sqrt { 2 } \beta g _ { V } ( P _ { a } ^ { ( Q ) } P _ { b } ^ { ( Q ) \dagger } - P _ { b } ^ { ( Q ) } P _ { a } ^ { ( \tilde { Q } ) \dagger } ) v _ { \mu } V _ { a b } ^ { \mu } } \\ & { + \sqrt { 2 } \beta g _ { V } ( P _ { a } ^ { * ( Q ) \dagger } P _ { b } ^ { * ( Q ) \dagger } - P _ { b } ^ { ( \tilde { Q } ) \mu } P _ { b } ^ { * ( \tilde { Q } ) \dagger } ) v _ { \mu } V _ { a b } ^ { \mu } } \\ & { - \sqrt { 2 } \beta _ { 2 } g _ { V } ( P _ { 1 a } ^ { ( Q ) } P _ { 1 b } ^ { ( Q ) \dagger } - P _ { 1 b } ^ { ( Q ) \mu } P _ { 1 a b } ^ { ( Q ) \dagger } ) v _ { \mu } V _ { a b } ^ { \mu } } \\ & { + \sqrt { 2 } \beta _ { 2 } g _ { V } ( P _ { 2 a } ^ { ( Q ) \alpha } P _ { 2 b } ^ { ( Q ) \dagger } - P _ { 2 b } ^ { ( Q ) \alpha } P _ { 2 a \alpha \beta } ^ { ( \tilde { Q } ) \dagger } ) v _ { \mu } V _ { a b } ^ { \mu } } \\ & { + [ \sqrt { 2 } \zeta _ { 1 } g _ { V } ( P _ { 2 a } ^ { ( Q ) \mu \alpha } P _ { b } ^ { ( Q ) \dagger } + P _ { 2 b } ^ { ( Q ) \mu \alpha } P _ { b } ^ { ( Q ) \dagger } ) ] v _ { a b } } \\ & { - \frac { i \zeta _ { 1 } g _ { V } } { \sqrt { 3 } } \epsilon _ { a \beta \gamma \delta } ( P _ { 1 a } ^ { ( Q ) \alpha } P _ { b } ^ { ( Q ) \dagger } + P _ { 1 b } ^ { ( Q ) \alpha } P _ { a } ^ { ( \tilde { Q } ) \dagger } ) v _ { \mu } \delta _ { \gamma } } \\ & { - \frac { 2 \zeta _ { 1 } g _ { V } } { \sqrt { 3 } } \epsilon _ { a \beta \gamma \delta } ( P _ { 1 a } ^ { ( Q ) } \sigma _ { b } ^ { ( Q ) \dagger } - P _ { 1 b } ^ { ( Q ) \alpha } P _ { a } ^ { ( \tilde { Q } ) \dagger } ) \sigma _ { b } v _ { \mu } ^ { \beta } } \\ & { - \frac { 2 \zeta _ { 1 } g _ { V } } { \sqrt { 3 } } ( P _ { 1 a } ^ { ( Q ) } P _ { b } ^ { ( Q ) \dagger } - P _ { 1 b } ^ { ( Q ) \alpha } P _ { a } ^ { ( \tilde { Q } ) \dagger } ) V _ { a b } ^ { \mu } + \mathrm { h . c . } ] , \quad ( \tilde { Q } ) } \end{array}
$$

where $a , b$ are the $\mathrm { S U } ( 3 )$ flavor indices and

$$
V = \left( \begin{array} { c c c } { { \frac { \omega } { \sqrt { 2 } } + \frac { \rho ^ { 0 } } { \sqrt { 2 } } } } & { { \rho ^ { + } } } & { { K ^ { * + } } } \\ { { \rho ^ { - } } } & { { \frac { \omega } { \sqrt { 2 } } - \frac { \rho ^ { 0 } } { \sqrt { 2 } } } } & { { K ^ { * 0 } } } \\ { { K ^ { * - } } } & { { \bar { K } ^ { * 0 } } } & { { \phi } } \end{array} \right) ,
$$

which satisfies $\mathcal { C } V \mathcal { C } ^ { - 1 } = - V ^ { T }$ . The fields for heavy mesons are collected into

$$
\begin{array} { r l } & { P ^ { ( c ) } = ( D ^ { 0 } , D ^ { + } , D _ { s } ^ { + } ) , } \\ & { P ^ { * ( c ) } = ( D ^ { * 0 } , D ^ { * + } , D _ { s } ^ { * + } ) , } \\ & { P _ { 1 } ^ { ( c ) } = ( D _ { 1 } ( 2 4 2 0 ) ^ { 0 } , D _ { 1 } ( 2 4 2 0 ) ^ { + } , D _ { { s } 1 } ( 2 5 3 6 ) ^ { + } ) , } \\ & { P _ { 2 } ^ { ( c ) } = ( D _ { 2 } ( 2 4 6 0 ) ^ { 0 } , D _ { 2 } ( 2 4 6 0 ) ^ { + } , D _ { { s } 2 } ( 2 5 7 3 ) ^ { + } ) , } \\ & { P ^ { ( b ) } = ( B ^ { + } , B ^ { 0 } , B _ { s } ^ { 0 } ) , } \\ & { P ^ { * ( b ) } = ( B ^ { * + } , B ^ { * 0 } , B ^ { * 0 } ) , } \\ & { P _ { 1 } ^ { ( b ) } = ( B _ { 1 } ( 5 7 2 1 ) ^ { + } , B _ { 1 } ( 5 7 2 1 ) ^ { 0 } , B _ { 1 } ( 5 8 3 0 ) ^ { + } ) , } \\ & { P _ { 2 } ^ { ( b ) } = ( B _ { 2 } ( 5 7 4 7 ) ^ { + } , B _ { 2 } ( 5 7 4 7 ) ^ { 0 } , D _ { 2 } ( 5 8 4 0 ) ^ { + } ) . } \end{array}
$$

Note that $P _ { 1 }$ and $P _ { 2 }$ are $P$ -wave mesons where the total angular momentum of light degrees of freedom is $s _ { l } = 3 / 2$ . The $P$ -wave mesons with $s _ { l } = 1 / 2$ will not be considered here because the charmed ones are too wide [6] to form bound states [73, 74] or considered as molecular states [75] and the bottomed ones have not been found experimentally.

# B. Coupling of light vector mesons and heavy baryons

In the heavy quark limit, the ground states of heavy baryons form an $\mathrm { S U } ( 3 )$ antitriplet with $\begin{array} { r } { J ^ { P } = \frac { 1 } { 2 } ^ { + } } \end{array}$ 2denoted by B(Q)¯3 and two degenerate sextets with JP = $( \frac { 1 } { 2 } , \frac { 3 } { 2 } ) ^ { + }$ denoted by $( B _ { 6 } ^ { ( Q ) } , B _ { 6 } ^ { ( Q ) * } )$ [68],

$$
\begin{array} { r l } & { B _ { 3 } ^ { ( c ) } = ( \begin{array} { c c } { 0 } & { \Lambda _ { + } ^ { c } } & { \frac { \varepsilon } { 2 } \le \frac { \varepsilon } { \varepsilon } } \\ { - \Lambda _ { + } ^ { c } } & { 0 } & { \frac { \varepsilon } { 2 } \le \sigma } \\ { - \frac { \varepsilon } { 2 \varepsilon } - \frac { \varepsilon } { 2 } \le \sigma } & { 0 } \end{array} ) , } \\ & { B _ { 6 } ^ { ( c ) } = ( \begin{array} { c c } { \sum _ { i = + } ^ { + + } \frac { { \varepsilon } } { \sqrt { 2 } } \sum _ { i = } ^ { + } \frac { { \varepsilon } } { \sqrt { 2 } } \frac { \Sigma _ { + } } { \varepsilon } \frac { \varepsilon } { \sqrt { 2 } } \frac { \Sigma _ { + } } { \varepsilon } } \\ { \frac { \varepsilon } { \sqrt { 2 } } \sum _ { i = + } ^ { + } \frac { { \varepsilon } } { \sqrt { 2 } } \frac { \Sigma _ { + } } { \varepsilon } \frac { \varepsilon } { \sqrt { 2 } } \frac { \Sigma _ { + } } { \varepsilon } } \\ { \frac { \varepsilon } { \sqrt { 2 } } \sum _ { i = } ^ { + } \frac { \varepsilon } { \sqrt { 2 } } \frac { \Sigma _ { + } } { \varepsilon } + \frac { \varepsilon } { \sqrt { 2 } } \frac { \Sigma _ { + } } { \sqrt { 2 } } \frac { \Sigma _ { + } } { \varepsilon } } \end{array} ) , } \\ &  B _ { 6 } ^ { ( c ) \star } = ( \begin{array} { c c } { \sum _ { i = + } ^ { + + } \frac { { \varepsilon } } { \sqrt { 2 } } \sum _ { i = + } ^ { + } \frac { { \varepsilon } } { \sqrt { 2 } } \frac { \Sigma _ { + } } { \varepsilon } + \frac { \varepsilon } { \sqrt { 2 } } \frac { \Sigma _ { + } } { \sqrt { 2 } } \frac { \Sigma _ { + } } { \varepsilon } + ) , } \\ { \frac { \varepsilon } { \sqrt { 2 } } \sum _ { i = + } ^ { + } \frac { { \varepsilon } } { \sqrt { 2 } } \frac { \Sigma _ { + } } { \varepsilon } \frac { \Sigma _ { 0 } } { \sqrt { 2 } } \frac { \Sigma _ { 0 } } { \varepsilon } \frac { \varepsilon } { \sqrt { 2 } } \frac { \Sigma _ { 0 } } { \varepsilon } \ } \\ { \frac { \varepsilon } { \sqrt { 2 } } \frac { \Sigma _ { + } } { 2 } \frac { \Sigma _ { 0 } } { \varepsilon } \frac { \varepsilon } { \sqrt { 2 } } \frac { \Sigma _ { 0 } } { \varepsilon } \frac { \varepsilon } { \sqrt { 2 } } \frac { \Sigma _ { 0 } } { \varepsilon } \frac { \varepsilon } { \sqrt { 2 } } \ } \\  B _ { 3 } ^ { ( b ) } = ( \begin{array}  c \end{array} \end{array} \end{array}
$$

TABLE I. The experimental candidates of heavy baryons predicted by quark model. The notations of experimental states are taken from RPP [6]. The $\Sigma _ { b } ^ { ( * ) 0 }$ , $\Xi _ { b } ^ { \prime 0 }$ and $\Omega _ { b } ^ { * 0 }$ do not have experimental candidates yet.   

<html><body><table><tr><td>model</td><td>experimental</td><td>model</td><td>experimental</td></tr><tr><td>A</td><td>A</td><td>A</td><td>A</td></tr><tr><td></td><td></td><td>三</td><td>三</td></tr><tr><td>三</td><td></td><td>三</td><td>三</td></tr><tr><td>£c</td><td>Σc(2455)</td><td>£</td><td>£</td></tr><tr><td></td><td></td><td>三</td><td>二</td></tr><tr><td></td><td></td><td>三</td><td>三6(5935)-</td></tr><tr><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Σc(2520)</td><td></td><td></td></tr><tr><td>三+</td><td>三c(2645)+</td><td>三</td><td>三6(5945)0</td></tr><tr><td></td><td>三c(2645)°</td><td></td><td>三6(5955)-</td></tr><tr><td>2</td><td>Ωc(2770)0</td><td>2</td><td>1</td></tr></table></body></html>

$$
B _ { 6 } ^ { ( b ) } = \left( \begin{array} { c c c } { { \Sigma _ { b } ^ { + } } } & { { \frac { 1 } { \sqrt { 2 } } \Sigma _ { b } ^ { 0 } } } & { { \frac { 1 } { \sqrt { 2 } } \Xi _ { b } ^ { \prime 0 } } } \\ { { \frac { 1 } { \sqrt { 2 } } \Sigma _ { b } ^ { 0 } } } & { { \Sigma _ { b } ^ { - } } } & { { \frac { 1 } { \sqrt { 2 } } \Xi _ { b } ^ { \prime - } } } \\ { { \frac { 1 } { \sqrt { 2 } } \Xi _ { b } ^ { \prime 0 } } } & { { \frac { 1 } { \sqrt { 2 } } \Xi _ { b } ^ { \prime - } } } & { { \Omega _ { b } ^ { - } } } \end{array} \right) ,
$$

$$
B _ { 6 } ^ { ( b ) * } = \left( \begin{array} { c c c } { { \Sigma _ { b } ^ { * + } } } & { { \frac { 1 } { \sqrt { 2 } } \Sigma _ { b } ^ { * 0 } } } & { { \frac { 1 } { \sqrt { 2 } } \Xi _ { b } ^ { * 0 } } } \\ { { \frac { 1 } { \sqrt { 2 } } \Sigma _ { b } ^ { * 0 } } } & { { \Sigma _ { b } ^ { * - } } } & { { \frac { 1 } { \sqrt { 2 } } \Xi _ { b } ^ { * - } } } \\ { { \frac { 1 } { \sqrt { 2 } } \Xi _ { b } ^ { * 0 } } } & { { \frac { 1 } { \sqrt { 2 } } \Xi _ { b } ^ { * - } } } & { { \Omega _ { b } ^ { * - } } } \end{array} \right) .
$$

Note that the heavy baryon multiplets have not been completely established experimentally and the experimental candidates in RPP [6] of the above baryons predicted by quark model are listed in Table I. The isospin averaged masses will be used in tbreaking will be considered. The $\Sigma _ { b } ^ { ( * ) 0 }$ o, $\Xi _ { b } ^ { \prime 0 }$ and nand $\Omega _ { b } ^ { * 0 }$ ospin have no experimental candidates, and thus we use $m _ { \Sigma _ { b } ^ { ( * ) } } =$ $\left( m _ { \Sigma _ { b } ^ { \left( * \right) + } } + m _ { \Sigma _ { b } ^ { \left( * \right) - } } \right) / 2$ and $m _ { \Xi _ { b } ^ { \prime } } = m _ { \Xi _ { b } ^ { \prime - } }$ .

The Lagrangian for the coupling of heavy baryons and light mesons is constructed as [32, 70]

$$
\begin{array} { c } { { { \mathcal { L } } _ { B B V } = i \beta _ { B } \mathrm { t r } \left[ \bar { B } _ { 3 } ^ { ( Q ) } v ^ { \mu } \left( \mathcal { V } _ { \mu } - \rho _ { \mu } \right) B _ { 3 } ^ { ( Q ) } \right] } } \\ { { - i \beta _ { B } \mathrm { t r } \left[ \bar { B } _ { 3 } ^ { ( \bar { Q } ) } v ^ { \mu } \left( \mathcal { V } _ { \mu } - \rho _ { \mu } \right) ^ { T } B _ { 3 } ^ { ( \bar { Q } ) } \right] } } \\ { { + i \beta _ { S } \mathrm { t r } \left[ \bar { S } _ { \nu } ^ { ( Q ) } v ^ { \mu } \left( \mathcal { V } _ { \mu } - \rho _ { \mu } \right) S ^ { ( Q ) \nu } \right] } } \\ { { - i \beta _ { S } \mathrm { t r } \left[ \bar { S } _ { \nu } ^ { ( \bar { Q } ) } v ^ { \mu } \left( \mathcal { V } _ { \mu } - \rho _ { \mu } \right) ^ { T } S ^ { ( \bar { Q } ) \nu } \right] , } } \end{array}
$$

where the heavy baryons are expressed as bispinors,

$$
\begin{array} { l } { { S _ { \mu } ^ { ( Q ) } = B _ { 6 \mu } ^ { ( Q ) * } - { \displaystyle \frac { 1 } { \sqrt { 3 } } } \left( \gamma _ { \mu } + v _ { \mu } \right) \gamma ^ { 5 } B _ { 6 } ^ { ( Q ) } , } } \\ { { \bar { S } _ { \mu } ^ { ( Q ) } = \bar { B } _ { 6 \mu } ^ { ( Q ) * } + { \displaystyle \frac { 1 } { \sqrt { 3 } } } \bar { B } _ { 6 } ^ { ( Q ) } \gamma ^ { 5 } \left( \gamma _ { \mu } + v _ { \mu } \right) , } } \end{array}
$$

TABLE II. Values of the coupling parameters used in the calculations.   

<html><body><table><tr><td>9v</td><td>β</td><td></td><td>S1</td><td>βB</td><td>βs</td></tr><tr><td>5.8</td><td>0.9</td><td>-0.9</td><td>0.16</td><td>0.87</td><td>−1.74</td></tr><tr><td>[72]</td><td>[77]</td><td>[78]</td><td>[78]</td><td>[70, 79]</td><td>[70, 79]</td></tr></table></body></html>

$v _ { \mu }$ is the four-velocity of the heavy field, and tr denotes the traces over both the spinor and light flavor spaces.

# III. MOLECULAR STATES FROM RESONANCE-SATURATED CONSTANT INTERACTIONS

In the following we will solve the Bethe-Salpeter equation $T = V + V G T$ [76] to search for poles of the scattering amplitude $T$ . The interaction kernel (potential) $V$ is defined as $V = - { \mathcal { M } }$ with $\mathcal { M }$ the $2  2$ invariant scattering amplitude so that a negative $V$ means an attraction interaction. Such a potential is also the same as the nonrelativistic potential in the Schr¨odinger equation up to a mass factor.

In Table II, we list the numerical values of the coupling constants used in this work with the corresponding references, which have been used in our previous work [32]. Note that the signs of $\beta _ { B }$ and $\beta _ { S }$ adapted in this work are different from those in Ref. [70], the choice of which is in conflict with the molecular interpretation of the famous $P _ { c }$ states as well as those obtained by flavor SU(4) relations [80].

# A. Potentials from light vector meson exchange

The constant potentials of different systems assuming the saturation of the light vector meson exchange can be expressed uniformly as3

$$
V \approx - F \tilde { \beta } _ { 1 } \tilde { \beta } _ { 2 } g _ { V } ^ { 2 } \frac { 2 m _ { 1 } m _ { 2 } } { m _ { \mathrm { e x } } ^ { 2 } } ,
$$

with $m _ { 1 } , m _ { 2 }$ and $m _ { \mathrm { e x } }$ the masses of the two heavy hadrons and the exchanged particle, respectively. $\tilde { \beta } _ { 1 }$ and ${ \tilde { \beta } } _ { 2 }$ are the coupling constants for the two heavy hadrons with the vector mesons and are explicitly given as terms of the couplings in Eqs. (1) and (10) as

• $\bar { \beta } _ { i } = \beta$ for the $S$ -wave charmed mesons, • $\bar { \beta } _ { i } = - \beta$ for the $P$ -wave charmed mesons, • $\bar { \beta } _ { i } = \beta _ { B }$ for the anti-triplet charmed baryons, $\bullet$ and $\tilde { \beta } _ { i } = - \beta _ { S } / 2$ for the sextet charmed baryons.

$F ^ { \dagger }$ is a group theory factor accounting for the lightflavor SU(3) information, and in our convention a positive $F$ means an attractive interaction. The values of $F$ for charmed-(anti)charmed and bottomed(anti)bottomed systems are listed in Tables VII, VIII, IX and X in Appendix A for all combinations of heavy-(anti)heavy hadron pairs (the ones for the heavyantiheavy systems have been given in our previous work [32]). Notice that we use the usual relativistic normalization for all the involved fields, i.e., a factor of $m _ { 1 } m _ { 2 }$ has been multiplied to the amplitude derived from the Lagrangian in Eqs. (1, 10) so as to get $V$ in Eq. (13).

It is important to note that the isoscalar meson exchange yields potentials with opposite signs for heavyheavy and heavy-antiheavy systems while the isovector exchange leads to potentials with the same sign. Such observations are confirmed formally in Appendix A.

# B. Poles of molecular states

Given the constant interactions between a pair of heavy-heavy hadrons, we solve the single channel BS equation that is factorized into an algebraic equation,

$$
T = { \frac { V } { 1 - V G } } ,
$$

to search for poles of the scattering amplitude and in turn to give a rough but overall picture of the spectrum of possible molecular states. Here $G$ is the one loop twobody propagator that after the dimensional regularization (DR) [81] reads4

$$
\begin{array} { c } { { G ( E ) = \displaystyle \frac { 1 } { 1 6 \pi ^ { 2 } } \Biggl \{ a ( \mu ) + \log \displaystyle \frac { m _ { 1 } ^ { 2 } } { \mu ^ { 2 } } + \frac { m _ { 2 } ^ { 2 } - m _ { 1 } ^ { 2 } + s } { 2 s } \log \displaystyle \frac { m _ { 2 } ^ { 2 } } { m _ { 1 } ^ { 2 } } } } \\ { { + \displaystyle \frac { k } { E } \Bigl [ \log \left( 2 k E + s + \Delta \right) + \log \left( 2 k E + s - \Delta \right) } } \\ { { - \log \left( 2 k E - s + \Delta \right) - \log \left( 2 k E - s - \Delta \right) \Bigr ] \Biggl \} , } } \end{array}
$$

where $s = E ^ { 2 }$ , $m _ { 1 }$ and $m _ { 2 }$ are the particle masses, $\Delta =$ $m _ { 1 } ^ { 2 } - m _ { 2 } ^ { 2 }$ , and

TABLE III. Pole positions of double-charm-hadron systems with $I \ = \ 0$ and $P = +$ . $E _ { \mathrm { t h } } ^ { \prime }$ in the second column is the threshold in MeV. The results as given in the last columns corresponds to using the cutoff $\Lambda = 0 . 5$ (1.0) GeV for Eq. (17) used to determine the subtraction constant $a ( \mu )$ in Eq. (15), respectively. In the last two columns, the first number in the parenthesis refers to the Riemann sheet (RS) where the pole is located while the second number means the distance between the pole position and the corresponding threshold, namely, $\begin{array} { r } { E _ { B } \equiv E _ { \mathrm { t h } } - E _ { \mathrm { p o l e } } } \end{array}$ , in units of MeV.

<html><body><table><tr><td></td><td>System|Eth [MeV]</td><td>JP</td><td></td><td>(RS,EB [MeV])</td></tr><tr><td></td><td></td><td></td><td>0.5 GeV</td><td>1.0 GeV</td></tr><tr><td>DD*</td><td>3876</td><td>1+ 1+</td><td>(2, 3.58)</td><td>(1, 5.96)</td></tr><tr><td>D*D* D1D1</td><td>4017 4844</td><td>1+</td><td>(2,2.68)</td><td>(1, 7.07)</td></tr><tr><td>D1D2</td><td>4885</td><td>(1,2,3)+</td><td>(2, 0.321)</td><td>(1, 12.2) (1, 12.4)</td></tr><tr><td>D2D2</td><td>4926</td><td>(1,3)+</td><td>(2, 0.277) (2, 0.237)</td><td>(1, 12.6)</td></tr><tr><td></td><td>4907</td><td>0+</td><td>(1, 2.72)</td><td>(1, 35.2)</td></tr><tr><td>三Ec</td><td>4939</td><td>1+</td><td>(2, 43.4)</td><td>(2, 10.1)</td></tr><tr><td></td><td>4972</td><td>(1,2)+</td><td>(1, 2.79)</td><td></td></tr><tr><td></td><td>5036</td><td>(0,2)+</td><td>(1, 2.86)</td><td>(1,35.1) (1, 35.1)</td></tr><tr><td>三三</td><td>5048</td><td>(0,1)+</td><td>(2, 40.1)</td><td>(2, 8.55)</td></tr><tr><td></td><td>5115</td><td>(1,2)+</td><td>(2, 38.3)</td><td>(2, 7.73)</td></tr><tr><td></td><td>5158</td><td>1+</td><td></td><td></td></tr><tr><td></td><td>5225</td><td>(1,2)+</td><td>(2, 36.9)</td><td>(2, 7.14)</td></tr><tr><td>三</td><td>5292</td><td></td><td>(2, 35.2)</td><td>(2, 6.4)</td></tr><tr><td>D1Ec</td><td>4891</td><td>(1,3)+</td><td>(2, 33.4)</td><td>(2, 5.7)</td></tr><tr><td>D2三c</td><td>4932</td><td>（+</td><td>(1,2.78)</td><td>(1,35.5)</td></tr><tr><td></td><td></td><td>+</td><td>(1, 2.83)</td><td>(1, 35.5)</td></tr><tr><td>D</td><td>5041</td><td></td><td>(1,2.94)</td><td>(1,3.4)</td></tr><tr><td>D1三</td><td>5068</td><td></td><td>(1, 2.96)</td><td>(1, 35.3)</td></tr><tr><td>D2三</td><td>5109</td><td>（，，+</td><td>(1,3.0)</td><td>(1, 35.3)</td></tr><tr><td>Ds1Ωc</td><td>5230</td><td></td><td>(1, 0.0298)</td><td>(1, 17.4)</td></tr><tr><td>Ds2Ωc</td><td>5264</td><td></td><td>(1, 0.039)</td><td>(1, 17.5)</td></tr><tr><td>Ds19</td><td>5301</td><td>（2,，）+</td><td>(1, 0.0474)</td><td>(1, 17.6)</td></tr><tr><td></td><td></td><td>（,,3）+（1,088） (177）</td><td></td><td></td></tr><tr><td>D82</td><td>5335</td><td></td><td></td><td></td></tr></table></body></html>

$$
k = { \frac { 1 } { 2 E } } \lambda ^ { 1 / 2 } ( E ^ { 2 } , m _ { 1 } ^ { 2 } , m _ { 2 } ^ { 2 } )
$$

is the corresponding three-momentum magnitude with $\lambda ( x , y , z ) = x ^ { 2 } + y ^ { 2 } + z ^ { 2 } - 2 x y - 2 y z - 2 x z$ for the K¨all´en triangle function. The DR scale $\mu$ is chosen to be 1 GeV and its variation can be absorbed into the subtraction constant $a ( \mu )$ . For the single channel case considered in our paper, there are two Riemann sheets (RSs) that are defined as $\operatorname { I m } ( k ) > 0$ on the first RS while $\operatorname { I m } ( k ) < 0$ on the second RS.

Another way to regularize the loop integral is to introduce a Gaussian form factor, namely5,

TABLE IV. Pole positions of double-charm-hadron systems with $I = 0$ and $P = -$ . See the caption for Table III.   

<html><body><table><tr><td>System</td><td>Eth [MeV]</td><td>JP</td><td>(RS,EB [MeV]) 0.5 GeV 1.0 GeV</td></tr><tr><td>D D1</td><td>4289</td><td>1-</td><td>(2, 2.48) (1, 6.94)</td></tr><tr><td>DD2</td><td>4330</td><td>2</td><td>(2, 1.65) (1, 8.69)</td></tr><tr><td>D*D1</td><td>4431</td><td>(0,1,2)−</td><td>(2, 1.35) (1, 9.12)</td></tr><tr><td>D*D2</td><td>4472</td><td>(1,2,3)−</td><td>(2,1.0) (1, 10.1)</td></tr><tr><td>DEc</td><td>4337</td><td>1-2</td><td>(1, 1.92) (1, 35.3)</td></tr><tr><td>DE</td><td>4446</td><td>1-2</td><td>(1, 2.04) (1, 35.4)</td></tr><tr><td>D*三c</td><td>4478</td><td>(,2)</td><td>(1, 2.19) (1, 35.5)</td></tr><tr><td>DE</td><td>4513</td><td></td><td>(1, 2.11) (1, 35.4)</td></tr><tr><td>D*三</td><td>4587</td><td></td><td>(1, 2.31) (1, 35.5)</td></tr><tr><td>D*三</td><td>4655</td><td></td><td>(1, 2.38) (1, 35.5)</td></tr><tr><td>DΩc</td><td>4664</td><td></td><td>(2, 0.168) (1, 14.3)</td></tr><tr><td></td><td></td><td>2</td><td></td></tr><tr><td>Ds</td><td>4734</td><td>3-2</td><td>(2, 0.129) (1, 14.6)</td></tr><tr><td>DS</td><td>4807</td><td>(，2）</td><td>(2, 0.0507) (1, 15.3)</td></tr><tr><td>D9</td><td>4878</td><td></td><td>(2, 0.0308) (1, 15.6)</td></tr></table></body></html>

TABLE V. Pole positions of double-charm-hadron systems with $I = 1 / 2$ and $P = -$ . See the caption for Table III.   

<html><body><table><tr><td>System</td><td>Eth [MeV]</td><td>JP</td><td>(RS,EB [MeV]) 0.5 GeV 1.0 GeV</td></tr><tr><td>D Ac</td><td>4154</td><td>1-2 (2, 3.44)</td><td>(1, 5.62)</td></tr><tr><td>D*Ac</td><td>4295</td><td></td><td>(2, 2.53) (1, 6.73)</td></tr><tr><td>DΩC</td><td>4321</td><td>1-23-2</td><td>(1, 5.81) (1, 50.5)</td></tr><tr><td>DE</td><td>4385</td><td></td><td>(1, 5.85) (1, 50.2)</td></tr><tr><td>D*c</td><td>4462</td><td>（）</td><td>(1, 5.97) (1, 49.7)</td></tr><tr><td>D*E</td><td>4527</td><td>(,,</td><td>(1, 6.01) (1, 49.5)</td></tr><tr><td>DsEc</td><td>4438</td><td></td><td>(2, 25.7) (2, 1.76)</td></tr><tr><td>DsE&#x27;</td><td>4547</td><td>1-21-2</td><td>(2, 23.7) (2,1.29)</td></tr><tr><td>D三c</td><td>4582</td><td></td><td>(2, 21.8) (2, 0.882)</td></tr><tr><td>Ds三</td><td>4614</td><td>3-2</td><td>(2, 22.6) (2,1.05)</td></tr><tr><td>D三</td><td>4691</td><td></td><td>(2, 20.0) (2, 0.564)</td></tr><tr><td>D三</td><td>4758</td><td>(,,</td><td>(2, 19.0) (2, 0.416)</td></tr></table></body></html>

TABLE VI. Pole positions of double-charm-hadron systems with $I = 1 / 2$ and $P = +$ . See the caption for Table III.   

<html><body><table><tr><td></td><td>System|Eth [MeV]</td><td>JP</td><td>(RS,EB [MeV]) 0.5 GeV 1.0 GeV</td></tr><tr><td>D1Ac</td><td>4708 (）+</td><td>(2, 1.04) (1, 9.31)</td><td rowspan="5"></td></tr><tr><td>D2Ac</td><td>4750 ，+</td><td>(2, 0.95) (1, 9.51) (1, 47.5)</td></tr><tr><td>D1£c</td><td>4876</td><td>+ (1, 6.25)</td></tr><tr><td>D2Σc</td><td>4917</td><td>(+ (1, 6.27) (1, 47.3)</td></tr><tr><td>D1E</td><td>4940</td><td>(1, 6.28) (1, 47.2)</td></tr><tr><td>D2</td><td>4981</td><td>（）+ （2,2,,3)+ (1,6.29)</td><td>(1, 47.0)</td></tr><tr><td>Ds1三c</td><td>5005</td><td>(,+</td><td>(2, 14.2) (2,0.00911)</td></tr><tr><td>Ds2Ec</td><td>5039</td><td>+</td><td>(2,13.8) (2,0.00176)</td></tr><tr><td>Ds1=</td><td>5114</td><td>+</td><td>(2,12.8） (1,0.00636)</td></tr><tr><td>Ds2E</td><td>5148</td><td></td><td>(2, 12.4) (1,0.0175)</td></tr><tr><td>Ds1=</td><td>5181</td><td>（，）+ （，,，）+ （2,11.6）</td><td>(2, 12.0) (1, 0.0319) (1,0.0532)</td></tr></table></body></html>

$$
G ( E ) = \int \frac { l ^ { 2 } d l } { 4 \pi ^ { 2 } } \frac { \omega _ { 1 } + \omega _ { 2 } } { \omega _ { 1 } \omega _ { 2 } } \frac { e ^ { - 2 l ^ { 2 } / \Lambda ^ { 2 } } } { E ^ { 2 } - ( \omega _ { 1 } + \omega _ { 2 } ) ^ { 2 } + i \epsilon } ,
$$

with $\omega _ { i } = \sqrt { m _ { i } ^ { 2 } + l ^ { 2 } }$ . The cutoff $\Lambda$ is chosen in the range of $0 . 5 \sim 1 . 0$ GeV, which is believed phenomenologically adequate [82–84], and then the subtraction constant $a ( \mu )$ in DR is determined by matching the values of $G$ from these two methods at threshold. In the following we will use the DR loop with the so-determined subtraction constant for numerical calculations.

In Tables III, IV, V and VI, we list all the pole positions of the double-charm-hadron systems which have attractive interactions, corresponding to the masses of hadronic molecules (bound states on 1st RS or virtual states on 2nd RS). For better illustration, these states are also shown in Figs. 1, 2, 3, 4, 5 and 6 together with the corresponding thresholds. Considering the constant contact interactions saturated by the light vector meson exchange with the coupled-channel effects neglected, we obtain a spectrum of 124 hadronic molecules in total. At least the same number of molecules are expected to exist for each of the charm-bottom and bottom-bottom systems since it is easier to form a bound state with the same attraction strength due to the heavier reduced masses; there could be even more as if the ground state is deeply bound excited states might exist as well as illustrated in the J¨ulich meson-exchange model for hidden-bottom pentaquark-like hadronic molecules in Ref. [85].

Besides the predicted molecular states mentioned above, where only $\omega , \rho$ and $\phi$ exchanges are considered, we need pay some extra attentions to the $K ^ { * }$ exchange, which is absent in the heavy-antiheavy systems due to the sizeable symmetry breaking between $s$ quark and $u / d$ quark. In most cases, $K ^ { * }$ exchange, if allowed, will contribute a repulsive potential, see Table VII, unless two channels are close enough and can be linearly combined to an isospin-like (called $U / V -$ spin in Ref. [86]) eigenstates. Explicitly, the thresholds of $D D _ { s } ^ { * }$ and $D ^ { * } D _ { s }$ are close enough and they may form two $U / V -$ spin eigenstates,

$$
U / V = \pm : D D _ { s } ^ { * } \pm D ^ { * } D _ { s }
$$

The potentials of $K ^ { * }$ exchange are repulsive and attractive, respectively, the strength of which can be also described by Eq. (13) with $| F | = 1$ and $m _ { \mathrm { e x } } = m _ { K ^ { * } }$ . Therefore, we expect a near threshold virtual or bound states in the $U / V = - 1$ systems of $D D _ { s } ^ { * }$ . Some other similar systems, such as $\Sigma _ { c } \Xi _ { c } ^ { * }$ and $\Sigma _ { c } ^ { * } \Xi _ { c }$ , the thresholds are not that close and more efforts should be paid to the coupled channel efforts, which is beyond the scope of this work.

# IV. DISCUSSIONS OF SELECTED SYSTEMS

# A. Heavy meson-meson molecules v.s. doubly heavy tetraquarks

From Table VII, one sees that the attractions strength for the isoscalar $D ^ { ( * ) } D ^ { * }$ is half of that for the isoscalar $C = + \ D ^ { ( * ) } \bar { D } ^ { * }$ pairs.6 Thus, for the $X ( 3 8 7 2 )$ as a $D \bar { D } ^ { * }$ bound state with $J ^ { P C } = 1 ^ { + + }$ ,7 the $D ^ { ( * ) } D ^ { * }$ system would be less. From Fig. 2 we see indeed that the isoscalar $D ^ { ( * ) } D ^ { * }$ systems are at the edge of forming bound states. While for the isovector ones, the potential from $\rho$ and $\omega$ exchange is repulsive and thus no molecules are expected. The situations for $D ^ { ( * ) } D _ { ( 1 , 2 ) }$ and $D _ { ( 1 , 2 ) } D _ { ( 1 , 2 ) }$ systems are all similar.

The $T _ { c c } ^ { + }$ state was recently observed in the invariant mass distribution of $D ^ { 0 } D ^ { 0 } \pi ^ { + }$ by LHCb [39, 40]. The pole from an analysis using a unitarized Breit-Wigner parameterization, considering the momentum-dependent width of the $D ^ { * }$ from its decays, is located in the complex energy plane at

$$
- 3 6 0 \pm 4 0 _ { - 0 } ^ { + 4 } - i ( 2 4 \pm 2 _ { - 7 } ^ { + 0 } ) \ \mathrm { k e V } ,
$$

with the real part defined as the energy relative to the $D ^ { 0 } D ^ { * + }$ threshold [40]. 8 This new state is a good candidate of the isoscalar $D D ^ { * }$ molecule, in agreement with our result. Before this experiment signal, lots of predictions of such doubly charmed tetraquark states, being either hadronic molecules [99–104] or compact tetraquark states [104–134], have been made with various methods.

# 1. Heavy meson-meson molecules

The doubly heavy tetraquark states in molecular configurations were widely investigated in the literature [88, 99–105, 135–164] where predictions of many doubly heavy tetraquark states including the $T _ { c c }$ mentioned above as well as other systems were made.

The interaction between a pair of heavy mesons was estimated using the Born-Oppenheimer approximation in the MIT bag model in Ref. [105]. The $I ( J ^ { P } ) = 0 ( 1 ^ { + } )$ di-meson $T ( b b { \bar { q } } { \bar { q } } )$ was found to be a bound state about 70 MeV below the $B B ^ { * }$ threshold while the situations of $T ( b c { \bar { q } } { \bar { q } } )$ and $T ( c c { \bar { q } } { \bar { q } } )$ were uncertain.

By solving the double-charm tetraquark system with two realistic potential models, it was found in Ref. [99] that the ground state tetraquark state has a configuration of $D D ^ { * }$ molecule. In the constituent quark model, it was also found that the di-meson configurations of $Q Q { \bar { q } } { \bar { q } }$ can be bound [104].

In Ref. [161], the $B ^ { ( * ) } B ^ { ( * ) }$ scattering amplitude was explored in the constituent interchange model and the $I ( J ^ { P } ) = 0 ( 1 ^ { + } )$ $B B ^ { * }$ and $B ^ { * } B ^ { * }$ bound states together with virtual states with some other quantum numbers were found.

In Ref. [136], it was found that the long-range potential from one-pion exchange may be attractive enough to bind the $B B ^ { * }$ system but insufficient for the $D D ^ { * }$ system to bind, which has a smaller reduced mass. The existence of $D D ^ { * }$ was also disfavored by the one pion exchange in Ref. [88]. While the one-boson exchange model predicts that the isoscalar $D D ^ { * }$ system can form an $S$ -wave bound state with a binding energy of 62.3 MeV (depending on the cutoff) with the $\pi , \rho$ and $\omega$ exchanges [100], $3 \sim 4 0$

![](images/08529ea30615de602a59214b402cb2a31db7634859681e98a987db6bdbc806f6.jpg)  
FIG. 1. The spectrum of hadronic molecules consisting of a pair of charmed mesons or baryons with $I = 0$ and $P = +$ . The colored rectangle, green for a bound state and orange for a virtual state, covers the range of the pole position for a given system with the cutoff $\Lambda$ varying in the range of [0.5, 1.0] GeV.Thresholds are marked by dotted horizontal lines. The rectangle closest to, but below, the threshold corresponds to the hadronic molecule in that system. In some cases, e.g., $D D ^ { * }$ , there are two rectangles for one system, with the upper edges exactly at the threshold. This corresponds to the situation that the pole moves from the second RS (left orange) to the first RS (right green) when $\Lambda$ increases in the considered range. In some other cases where the pole positions of two systems overlap, small rectangles are used with the left (right) one for the system with the higher (lower) threshold.

![](images/f542eb87dc996c2b171d9c6eea9054a45b1e4c648d2ac5e3b81a121f93286018.jpg)  
FIG. 2. The spectrum of hadronic molecules consisting of a pair of charmed mesons with $I ~ = ~ 0$ and $P = -$ . See the caption for Fig. 1.

MeV with the $\pi , \rho$ and $\omega$ exchanges [103], $0 . 4 7 \sim 4 3$ MeV (depending on the cutoff) after including the $\pi , \sigma , \rho$ and $\omega$ exchanges and coupled channel effects [101] or $3 _ { - } ^ { + 1 5 }$ MeV without coupled channels but with the cutoff fixed by producing the correct binding energy of $X ( 3 8 7 2 )$ [102]. Besides, some other doubly heavy molecules including $D _ { ( s ) } ^ { ( * ) } D _ { ( s ) } ^ { ( * ) }$ , $\bar { B } _ { ( s ) } ^ { * } \bar { B } _ { ( s ) } ^ { ( * ) }$ and $D ^ { ( * ) } \bar { B } ^ { ( * ) }$ with different quantum numbers are predicted in these works as well as in Ref. [164]. In Ref. [143], the potential between $D D ^ { * }$ from the one-pion exchange supplemented by the contact term and the exchange of two pions was investigated in a chiral effective field theory, and an isovector state was found to be bound while the scalar one was not.

With the potential from a chiral constituent quark model, the Lippmann–Schwinger equation was solved for the $D D { - } D D ^ { * } { - } D ^ { * } D ^ { * }$ coupled channels in Ref. [141] and a stable doubly charmed meson with $I ( J ^ { P } ) = 0 ( 1 ^ { + } )$ was predicted. In Ref. [144], the similar strategy yielded isoscalar $0 ^ { + }$ and $1 ^ { + }$ bcq¯q¯ bound states, which are stable against strong interaction, but the isovector systems were found unbound.

We can notice that the results from these works, as well as those obtained here, do not all agree with each other. There are at least two possible reasons: the form of the potential, in particular the treatment of the shortdistance part, is different; the parameter values are different. In the spirit of effective field theory, different treatments of the short-distance potential correspond to taking different values for the contact terms. In any case, most of the literature tends to agree that it is easier for the isoscalar $D D ^ { * } / B B ^ { * }$ to bind than the isovector combinations, as is the conclusion in our paper as well. Our model assumes the short-distance contact terms are saturated by the light-vector-meson exchange, and the longor mid-range attractive potential from the $\pi$ or $\sigma$ exchanges and the coupled channel effects may change the hadronic molecule spectrum quantitatively to some extent.

![](images/978260cf8c94a7a96a2a76d1075feb8fca083fabaf8db6cf83fc5ef122d6a729.jpg)  
FIG. 3. The spectrum of hadronic molecules consisting of a pair of charmed meson and charmed baryon with $I = 1 / 2$ and $P = -$ . See the caption for Fig. 1. The right part of the dashed line for $D ^ { * } \Lambda _ { c }$ marks the real threshold while the left part is deformed to avoid being covered by the rectangle of $D \Sigma _ { c }$ system.

![](images/d51e680c69e8ef499f890bbf93916e6299c4da124bbaeb48287241ea82b2d686.jpg)  
FIG. 4. The spectrum of hadronic molecules consisting of a pair of charmed meson and charmed baryon with $I = 0$ and $P = -$ See the caption for Fig. 1.

![](images/75c5381266cdc5d0e8773c915cbc9e07a440366d2d4ff88a034ba00687fd47fc.jpg)  
FIG. 5. The spectrum of hadronic molecules consisting of a pair of charmed meson and charmed baryon with $I = 1 / 2$ and $P = +$ . See the caption for Fig. 1.

![](images/be66fc3f445345437185d7d7cc52411c1267906f333ec350962718c15dd21dfe.jpg)  
FIG. 6. The spectrum of hadronic molecules consisting of a pair of charmed meson and charmed baryon with $I = 0$ and $P = +$ See the caption for Fig. 1.

There are also lattice calculations of the potential between a pair of heavy mesons [135, 137, 138, 147, 148]. The $D D ^ { ( * ) }$ interactions were calculated on lattice [149] and it was found that the potentials of the isovector systems are repulsive while those of the isoscalar systems are attractive, qualitatively in line with the contact interactions from the vector meson exchange reported here (see Table VII). The isoscalar $B ^ { ( * ) } B ^ { ( * ) }$ interaction from lattice calculations [146, 150–155] in the static $b$ quark limit is attractive in the short range while for the isovector one, the attraction is weaker. It was found plausible for $\bar { b } \bar { b } q q$ di-mesons to be stable under strong interactions [145]. In Refs. [152–156], the Schr¨odinger equation with the obtained potential yields results that the $I ( J ^ { P } ) = 0 ( 1 ^ { + } )$ ¯b¯bqq system has an attractive potential between two $B ^ { ( * ) }$ mesons strong enough to form bound states but not strong enough in the isovector case. A recent analysis on lattice [165] shows that the mesonmeson component in the $I ( J ^ { P } ) = 0 ( 1 ^ { + } ) ~ b b$ ud state has a fraction around $6 0 \%$ .

# 2. Compact tetraquark states

Besides the molecular assignment, many works have investigated the compact doubly heavy tetraquarks via various methods, including quark potential models [106– 108, 122, 166–178], quark models with heavy quark symmetries [109, 119, 120], QCD sum rules [111, 121, 179– 188] and lattice QCD [123, 125, 189–194].

In the quark potential models, it was found that the $\bar { Q } \bar { Q } q q$ is possible to be bound below the two-meson threshold for certain potentials [166–169] but no bound states can be found if all quarks have the same mass, which was confirmed recently in a four-body calculation [172]. It was also found [173] that although the possible configurations of tetraquarks proliferate, only five of the candidates are stable, namely, ccq¯q¯ with $J ^ { P } ( L , S , I ) = 1 ^ { + } ( 0 , 1 , 0 )$ and bbq¯q¯ with $J ^ { P } ( L , S , I ) =$ $1 ^ { + } ( 0 , 1 , 0 ) , \ 3 ^ { - } ( 1 , 2 , 1 ) , \ 0 ^ { + } ( 0 , 0 , 0 )$ and $1 ^ { - } ( 1 , 0 , 0 )$ , where $L$ and $S$ refer to the orbital angular momentum and total spin of the two mesons that couple to the tetraquark, among which the last one has a molecular nature. The doubly charmed system was also confirmed to be bound in Ref. [195] using different potential models while in Ref. [196] only one doubly-bottomed system with $I ( J ^ { P } ) = 0 ( 1 ^ { + } )$ was found to be located below the threshold of the corresponding meson pair. With an adequate treatment of the four-body dynamics in the quark model picture of tetraquark states, it was found in Ref. [197] that the $I ( J ^ { P } ) = 0 ( 1 ^ { + } )$ ccu¯ ¯d system is at the edge of binding while the doubly-bottomed system is easier to be bound. On the other hand, the analysis within the chiral $\mathrm { S U } ( 3 )$ quark model [198] or the relativistic quark model [112] found that the $I ( J ^ { P } ) = 0 ( 1 ^ { + } )$ ccu¯ ¯d state is not bound but above the thresholds for decays into open charm mesons. In Ref. [163], two bound states of $I ( J ^ { P } ) = 0 ( 1 ^ { + } )$ bbu¯ ¯d were found in a constituent quark model, one deeply bound compact tetraquark and one $B B ^ { * }$ molecule.

In Ref. [199], the masses of tetraquark states were obtained model-independently with known hadron masses as input and it was found that four-quark states containing two identical heavy quarks have a good probability of being stable against strong decay. In Ref. [119], the ground states of hadrons are described by the quark model and therein the mass of the predicted $J ^ { P } = 1 ^ { + }$ $c c \bar { u } \bar { d }$ state reads $3 8 8 2 \pm 1 2$ ) MeV using the measured $\Xi _ { c c } ^ { + + }$ mass [200] as input, which nicely covers the LHCb result. Ref. [119] also predicts a $1 ^ { + }$ bbu¯ ¯d state to be at (10389 $\pm$ 12) MeV, which is well below the $B B ^ { * }$ threshold and thus stable under strong and electromagnetic interactions.

By implementing the heavy antiquark-diquark symmetry [201], the mass of doubly-heavy tetraquark states may be predicted using the relation

$$
m ( Q Q \bar { q } \bar { q } ) - m ( Q Q q ) \approx m ( Q q q ) - m ( Q \bar { q } ) ,
$$

the essence of which can be traced back to Refs. [202, 203]. For instance, after the double-charm baryon $\Xi _ { c c } ^ { + + }$ was observed [200], the lightest double-bottom tetraquark state was predicted in Ref. [120] to be at 10482 MeV, which is below the $B B ^ { * }$ threshold and stable under strong and electromagnetic interactions, with $J ^ { P } = 1 ^ { + }$ , using the doubly-bottom baryon masses in Ref. [204] as input. The mass of ccu¯ ¯d was determined in this way to be 3845 or 3905 MeV [109], 3978 MeV [120], $( 3 9 4 7 \pm 1 1$ ) MeV [130], 3900 MeV [116] and 3929 MeV [132], see also the discussion in Ref. [205]. The spectrum of some other doubly-heavy tetraquark states were also obtained in these works, including stable bbq¯q¯ tetraquark states. Note that different from the case of doubly-heavy baryons, where the heavy diquark must be in a color anti-triplet, the two heavy quarks inside a doubly-heavy tetraquark can be in either a color anti-triplet or a color sextet. The approximate heavy antiquark-diquark symmetry is applicable only when the color sextet component of the diquark can be neglected and when the two heavy quarks are close to each other so that they acts as a pointlike color-antitriplet source just like a heavy antiquark. Thus, it cannot be applied to relate the heavy-heavy molecular systems to singly-heavy baryons. Tetraquarks with the two charm quarks as a compact diquark may exist in addition to the molecular states. The mixing of these two configurations will make the spectrum more complicated.

The spectrum of $Q Q { \bar { q } } { \bar { q } }$ tetraquark states are explored via the method of QCD sum rules in Refs. [111, 121, 179– 188]. In Ref. [180] it was argued that the molecular current of $D D ^ { * }$ yields a similar mass with that of the $D \bar { D } ^ { * } + c . c$ . molecule and thus the result will perfectly match $T _ { c c } ^ { + }$ mass measured by LHCb if $X ( 3 8 7 2 )$ is a

$D \bar { D } ^ { * } + c . c$ . molecule. The mass of the ccu¯ ¯d ground state with $J ^ { P } = 1 ^ { + }$ was determined to be $3 . 9 0 \pm 0 . 0 9$ ) GeV in Refs. [121, 182], which is also consistent with LHCb result. While in other works, it was found that usually the $J ^ { P } = 1 ^ { + }$ bbu¯ ¯d state lies below the threshold of $B B ^ { * }$ [111, 184, 185] while the charmed one is above the corresponding $D D ^ { * }$ threshold [111, 179, 185].

The explorations of doubly-heavy compact tetraquark states on lattice can be seen in, e.g., Refs. [123, 125, 189– 194, 206]. Deeply bound tetraquark states, ud¯b¯b, qs¯b¯b and ud¯bc¯ with $J ^ { P } = 1 ^ { + }$ are predicted in Refs. [190, 193], which are $1 8 9 \pm 1 0$ , $9 8 \pm 7$ and $1 5 \sim 6 1$ MeV below the corresponding free two-meson thresholds, respectively. Ref. [125] obtained similar results for the above systems and predicted another three bound states of $u c b b$ , $u d \bar { c } \bar { c }$ and $u s c \bar { c } \bar { c }$ located just below the corresponding free two-meson thresholds, and the masses of the doublecharm states are in agreement with those obtained in Ref. [123]. In Ref. [194], the tetraquark operators for bbu¯ ¯d are constructed in both diquark-antidiquark $( [ b b ] [ \bar { u } d ] )$ and molecular $( [ b \bar { u } ] [ b \bar { d } ] )$ configurations and two states were found on lattice, a compact tetraquark located at $1 8 9 \pm 1 8$ MeV below $B B ^ { * }$ threshold and a molecular one $1 7 \pm 1 4$ MeV above the same threshold.

# B. Heavy meson-baryon molecules v.s. doubly heavy baryons

Different from the meson-meson case, from Table VII we can see that double-charm meson-baryon systems are more attractive or less repulsive than the hidden-charm ones. Specifically, the D(∗)Σ(∗)c systems with isospin- $1 / 2$ are more attractive than the isospin- $1 / 2 \bar { D } ^ { ( * ) } \Sigma _ { c } ^ { ( * ) }$ systems while the latter are widely believed to be able to form bound states with experimental candidates, namely, the famous $P _ { c }$ states [15]. Therefore, it is natural that more deeply bound states of $D ^ { ( * ) } \Sigma _ { c } ^ { ( * ) }$ exist, see Fig. 3. Similar conclusions can be drawn for $D _ { 1 , 2 } \Sigma _ { c } ^ { ( * ) }$ systems, as shown in Fig. 5, since they have the same form of leading order interactions. Other systems including $D ^ { ( * ) } \Xi _ { c } ^ { ( \prime * ) }$ $D _ { 1 , 2 } \Xi _ { c } ^ { ( \prime * ) }$ , $D _ { s } ^ { ( * ) } \Omega _ { c } ^ { ( * ) }$ and $D _ { s 1 , s 2 } \Omega _ { c } ^ { ( * ) }$ are also predicted to be bound easily, the spectra of which are shown in Figs. 4 and 6.

Similarly with the coupled channel analysis used in the pioneering works [80, 207] of pentaquark states where the $P _ { c }$ states were successfully predicted, Ref. [208] extended such a study to the double-charm systems and some deeply bound states of $D ^ { ( * ) } \Sigma _ { c } ^ { ( * ) }$ with binding energies of $\mathcal { O } ( 1 0 0 \ \mathrm { M e V } )$ were found. It was extended further to the charm-bottom system and double-bottom systems in Refs. [209, 210], and more deeply bound states of $D ^ { ( * ) } \Sigma _ { b } ^ { ( * ) }$ and $\bar { B } ^ { ( * ) } \Sigma _ { c } ^ { ( * ) }$ with binding energies of $\mathcal { O } ( 3 0 0 ~ \mathrm { M e V } )$ and $\bar { B } ^ { ( * ) } \Sigma _ { b } ^ { ( * ) }$ with binding energies of $\mathcal { O } ( 4 0 0 \mathrm { M e V } )$ were obtained. There it was also found that there are poles located about 100 MeV below the $\Lambda _ { b } D$ , $\Lambda _ { c } B$ and $\Lambda _ { b } B$ thresholds, respectively. Such conclusions are qualitatively consistent with our results that D(∗)Σ(∗)c and D(∗)Ξ(∗)c are attractive and the former is stronger. The meson-baryon transitions between the coupled channels $J / \psi N { - } \Lambda _ { c } \bar { D } ^ { ( * ) } { - } \Sigma _ { c } ^ { ( * ) } \bar { D } ^ { ( * ) }$ were explored in Ref. [211] and it was found that a doubly-charmed state, $\Xi _ { c c } ^ { * } ( 4 3 8 0 )$ exists with almost the same mass as $P _ { c } ( 4 3 8 0 )$ . An S-wave scattering of ground state doubly-charmed baryons with the light pseudoscalar mesons were first investigated in Ref. [74] and then in Ref. [212] by means of unitarized chiral effective theory and several doubly charmed baryon resonances were predicted. The spectrum was modified by including the effects of the $P$ -wave excitation inside the charm diquark in Ref. [213].

The interaction between $D \Lambda _ { c }$ or $\bar { B } \Lambda _ { b }$ from two-pion exchange are investigated in Ref. [214] and it was claimed that a $\bar { B } \Lambda _ { b }$ bound state from such an interaction is possible. In Ref. [215], the $D \Lambda _ { c / b }$ , $B \Lambda _ { c / b }$ systems were found possible to be bound by the $\sigma / \omega$ exchange interaction. Systematic studies on the $\Sigma _ { c } ^ { ( * ) } D ^ { ( * ) }$ interactions within the framework of chiral effective field theory [216] or one boson exchange [103] were performed, and the $I = 1 / 2$ systems may form bound states with binding energies of about several or dozens MeV, consistent with the results obtained here, see Table V. Therein, deeper bound states of the $\Sigma _ { c } ^ { ( * ) } \bar { B } ^ { ( * ) } , \Sigma _ { b } ^ { ( * ) } D ^ { ( * ) }$ and $\Sigma _ { b } ^ { ( * ) } \bar { B } ^ { ( * ) }$ systems were also predicted to exist due to the larger reduced masses, as expected.

The doubly-heavy pentaquark states with compact configurations were explored within the color-magnetic interaction model [217], non-relativistic constituent quark model [218] and QCD sum rules [219, 220] where some narrow exotic pentaquark states were predicted, constituent quark model [221] where one stronginteraction stable state, ccuds¯ was predicted.

From Table V and Fig. 3, one sees that the lightest double-charm meson-baryon molecule is the one in the $D \Lambda _ { c }$ system. The state has a mass large enough for it to decay into $\Xi _ { c c } \pi$ and could be broad. So are the other similar states.

# C. Heavy di-baryons

For heavy di-baryons, the leading order interaction from the veconly for the $\Sigma _ { c } ^ { ( * ) } \Sigma _ { c } ^ { ( * ) }$ n exchange leads to evident bindingsystems, see Table III and Fig. 1. The attractions for the $\Xi _ { c } \Xi _ { c }$ related systems are too weak and only remote virtual poles are found, which are not robust somehow and can get sizeably modified by the omitted momentum-dependent terms.

In our simple model the leading order interaction for the $\Lambda _ { c } \Lambda _ { c }$ system is repulsive and thus it cannot be bound. Within various models, it was found that the $\Lambda _ { c } \Lambda _ { c }$ system can not be bound by itself [222–227] but Refs. [223–225, 228] showed that the coupling to the strongly attractive Σ(∗)c Σ(∗)c system may lead to a states below $\Lambda _ { c } \Lambda _ { c }$ threshold . In an analysis with QCD sum rules [229], the states with the same quark components as $\Lambda _ { c } \Lambda _ { c }$ were found all above the $\Lambda _ { c } \Lambda _ { c }$ threshold. In Refs. [215, 230, 231], on the contrary, the single channel $\Lambda _ { c } \Lambda _ { c }$ can be bound by itself; however, Ref. [231] warns that a more thorough theoretical exploration is needed to determine whether the $\Lambda _ { c } \Lambda _ { c }$ system really binds.

Some other doubly-heavy di-baryon systems were also explored. Several realistic phenomenological nucleonnucleon interaction models are employed in Ref. [232]. It was found there that the $\Xi _ { c } ^ { ( \prime ) } \Xi _ { c } ^ { ( \prime ) }$ and $\Sigma _ { c } \Sigma _ { c }$ systems can be bound in some models. From one-boson exchange with coupled channel effects included, Refs. [222, 233] found that Ξ(0∗)c Ξ(0∗)c while the is $\Omega _ { c } ^ { ( * ) } \Omega _ { c } ^ { ( * ) }$ may be loosely bounds can be deeply bound. $\Sigma _ { c } ^ { ( * ) } \Sigma _ { c } ^ { ( * ) }$ Similar conclusion was obtained in Ref. [224] within the framework of quark delocalization color screening model that the $\Sigma _ { c } ^ { ( * ) } \Sigma _ { c } ^ { ( * ) }$ single-channel system can be deeply bound. In Ref. [227], the potential of $\Sigma _ { c } \Sigma _ { c }$ was derived from a constituent quark model and a bound state with $I ( J ^ { P } ) = 0 ( 0 ^ { + } )$ was obtained with a binding energy about 6.2 MeV. The long-range pion exchange force is strong enough to form molecules of $[ \Sigma _ { Q } \Lambda _ { Q } ] _ { J = 1 } ^ { I = 1 } \left( Q = b , c \right)$ , $\begin{array} { r } { \left[ \sum _ { b } \Xi _ { b } ^ { \prime } \right] _ { J = 1 } ^ { I = 3 / 2 } } \end{array}$ and $[ \Xi _ { b } \Xi _ { b } ^ { \prime } ] _ { J = 1 } ^ { I = 0 }$ $\left[ \Sigma _ { Q } \Xi _ { Q } ^ { \prime } \right] _ { J = 1 } ^ { I = 1 / 2 }$ J=1  where , the $S$ - $D$ mixing is necessary [228]. In Ref. [231], the $\Sigma _ { Q } ^ { ( * ) } \Sigma _ { Q _ { * } } ^ { ( * ) }$ were claimed to be good candidates of bound states from the one-pion and vector meson exchanges while it concludes that a more thorough analysis is necessary to determine whether there is a binding for the $\Lambda _ { \cal Q } \Sigma _ { \cal Q } ^ { ( * ) }$ .

The di-baryon systems with two heavy quarks were investigated in Ref. [234] with a simple quark model but no bound or metastable state was found.

# V. SUMMARY

In this work we have obtained an overall spectrum of hadronic molecules composed of a pair of charmed hadrons, including all the $S$ -wave singly-charmed mesons and baryons as well as the $s _ { \ell } = 1 / 2$ $P$ -wave charmed mesons. The interaction is assumed to be dominated by the light vector meson exchange and approximated by constants at leading order, which are derived systematically from the couplings that satisfy HQSS and SU(3) flavor symmetry.

One should keep in mind that the spectrum predicted here should be regarded as the leading approximation of the spectrum for heavy-heavy molecular states, which gives only a general overall feature of the heavy-heavy hadronic molecular spectrum. The numerical results can receive large quantitative corrections due to the limitations of our treatments, which we discuss qualitatively in the following.

• We have only considered the leading interactions described by constant contact terms. The momentum dependent terms (including both spindependent and spin-independent contributions) may change the spectrum we obtained visibly, especially for the systems where the poles are far away from the corresponding thresholds. The spindependent terms will also lift the degeneracy of the same system with different total spins.

• The coupled channel effects have been neglected. In some cases the coupled-channel effects may play an important role in the formation of near threshold states. However, it is common and natural that the near-threshold pole found in a coupled-channel system dominantly couples to a single channel, see, e.g., the $D _ { s 0 } ^ { * } ( 2 3 1 7 )$ , which is dynamically generated in the $D K$ and $\mathit { D _ { s } } \eta$ system but couples dominantly to $D K$ [93, 235, 236], and the $\Xi _ { c c } ( 4 0 8 3 )$ state with $J ^ { P } = 1 / 2 ^ { - }$ , which is dynamically generated in the $\Sigma _ { c } D$ and $\Xi _ { c } ^ { \prime } D _ { s }$ system but couples dominantly to $\Sigma _ { c } D$ [208].9

• The hadronic molecules shown in Figs. 3-6 can couple to normal double-charm baryons as well as channels with a double-charm baryon and a light meson. It is expected that each of these two types of systems also forms a spectrum. The physical spectrum of double-charm baryons should incorporates the mixing among all the three spectra. Coupled channels including both the charmbaryon–charm-meson channels and light-meson– double-charm-baryon channels have been considered in, e.g., Ref. [208] for the $\Xi _ { c c }$ type molecular states. Mixing of light-meson–double-charmbaryon molecular states with the normal doublecharm baryons with a $P$ -wave excitation inside the charm diquark has been considered in Ref. [213]. Yet, a model considering all the three kinds of channels does not exist so far.

• The exchange of other particles, such as the light scalar mesons, charmed mesons and charmonia, are not considered, the effect of which can be partly covered by varying the cutoff. In addition, the interactions considered here are of leading order in the $1 / N _ { c }$ expansion, where $N _ { c }$ is the number of colors, i.e., the Okubo-Zweig-Iizuka violating interactions have been neglected. Such contributions will also lift the degeneracy of the same system with different total spins.

Therefore, although we expect the spectrum given here should present an overall pattern of the hadronic molecules formed by a pair of charmed mesons and/or baryons, specific systems may quantitatively differ from the predictions here due to the limitations of our treatments.

In total we obtained 124 double-charm hadronic molecules and we summarize the main feature of this spectrum in the following.

1. Unlike the isovector $D ^ { * } D ^ { ( * ) }$ systems that are repulsive, the isoscalar ones have attractive interaction from the light vector meson exchange and the total potential makes the systems at the edge of forming near-threshold molecules. With a reasonable cutoff regularizing the loop integral, the binding energy of the $I ( J ^ { P } ) = 0 ( 1 ^ { + } )$ $D D ^ { * }$ system is consistent with the double charm tetraquark $T _ { c c } ^ { + }$ in LHCb observation. If the hadronic molecule structure of the $T _ { c c } ^ { + }$ is confirmed, which is rather natural given the closeness to the $D D ^ { * }$ threshold, many other similar states with $I = 0$ including $D ^ { * } D ^ { * }$ , $D ^ { ( * ) } D _ { 1 , 2 }$ , $D _ { 1 , 2 } D _ { 1 , 2 }$ can also exist.

2. Given that the famous $P _ { c }$ states are hadronic molecules of $\bar { D } ^ { ( * ) } \Sigma _ { c } ^ { ( * ) }$ , it is natural to expect the existence of double-charm $D ^ { ( * ) } \Sigma _ { c } ^ { ( * ) }$ and $D _ { 1 , 2 } \Sigma _ { c } ^ { ( * ) }$ states with $I = 1 / 2$ because the attraction from the light vector meson exchange for the latter is stronger than that for the former. Similar conclusions can be made for the $D ^ { ( * ) } \Xi _ { c } ^ { ( \prime * ) }$ and $D _ { 1 , 2 } \Xi _ { c } ^ { ( \prime * ) }$ channels, especially when the $P _ { c s }$ states are established experimentally. The hadronic molecules in other systems including $D ^ { ( * ) } \Lambda _ { c }$ , $D _ { 1 , 2 } \Lambda _ { c }$ , $D _ { s } ^ { ( * ) } \Xi _ { c } ^ { ( \prime * ) }$ $D _ { s 1 , 2 } \Xi _ { c } ^ { ( \prime * ) } D _ { s } ^ { ( * ) } \Omega _ { c } ^ { ( * ) }$ and $D _ { s 1 , 2 } \Omega _ { c } ^ { ( \ast ) }$ are also predicted.

3. Within our simple model, inbaryon sector, only isoscalar $\Sigma _ { c } ^ { ( * ) } \Sigma _ { c } ^ { ( * ) }$ le-charm di-systems are expected to be good candidates of bound di-baryon states. As discussed in the literature, the inclusion of other contributions to the interaction as well as the coupling to other channels may make additional di-baryon bound states possible.

Due to the heavy quark flavor symmetry, the potentials in the bottom sector are the same as those in the charm sector, if using the nonrelativistic field normalization, and we expect at least the same number of molecular states in the analogous systems therein. Because of the much heavier reduced masses of hidden-bottom system, it will be easier to form bound states than the charmed systems, and there may even be excited states if the ground states are deeply bound, the treatment of which, however, requires momentum-dependent interactions and is beyond the scope of this paper.

# ACKNOWLEDGMENTS

We would like to thank Marek Karliner and Eulogio Oset for useful comments and Ming-Zhu Liu for pointing out a mistake about the quantum numbers of a pair of identical fermions. This work is supported in part by the Chinese Academy of Sciences (CAS) under Grant No. XDPB15, No. XDB34030000 and No. QYZDBSSW-SYS013, by the National Natural Science Foundation of China (NSFC) under Grant No. 11835015, No. 12047503 and No. 11961141012, and by the NSFC and the Deutsche Forschungsgemeinschaft (DFG, German Research Foundation) through funds provided to the Sino-German Collaborative Research Center “Symmetries and the Emergence of Structure in QCD” (NSFC Grant No. 12070131001, DFG Project-ID 196253076 – TRR110).

# Appendix A: The flavor factor $F ^ { \prime }$

In this section we list the factor $F$ that accounts for the flavor information for the exchange of different mesons in different systems. The essential point is that the vector mesons, $\rho , \omega$ and $\phi$ , only couple to the light quark in heavy or antiheavy hadron. The conclusion is that the isoscalar vector, $\omega$ and $\phi$ , exchange have opposite signs for $q q$ and $q q$ interactions while the isovector meson, $\rho$ , exchange has the same sign in these two cases. Note that the negative $C$ -parity of vector mesons has been taken into account. The conclusion for isoscalar meson exchange is apparent and in the following we give a brief deduction for the case of isovector exchange.

For simplicity, we consider the hadrons that contain only one $u$ or $d$ quark. The Lagrangian for the isospin structure, taking the $\rho$ meson exchange for example, reads

$$
{ \mathcal { L } } = \psi ^ { \dagger } \rho \cdot \tau \psi + { \mathrm { c . c . } }
$$

with $\psi = ( u , d ) ^ { T }$ , $\psi ^ { \dagger } = ( u ^ { \dagger } , d ^ { \dagger } )$ , $_ \tau$ the Pauli matrices, where $T$ means transpose. Note that here we are only interested in the flavor structure and hence we denote the field creating a $u$ quark by $u ^ { \dagger }$ instead of $u$ to avoid confusion with the field for antiquark below. The charge conjugation term, which needs special attentions, is

$$
c \bar { \psi } ^ { \prime } { } ^ { \dagger } ( \pmb { \rho } \cdot \tau ) ^ { T } \bar { \psi } ^ { \prime }
$$

with $\bar { \psi } ^ { \prime } = ( \bar { u } , \bar { d } ) ^ { T }$ , $\bar { \psi } ^ { \prime } { } ^ { \dagger } = ( \bar { u } ^ { \dagger } , \bar { d } ^ { \dagger } )$ and $c = - 1$ the charge conjugation factor for the $\rho$ meson. Using the common convention for the isospin eigenstates,

$$
\left| u \right. = \left| \uparrow \right. , \left| d \right. = \left| \downarrow \right. , \left| \bar { d } \right. = \left| \uparrow \right. , \left| \bar { u } \right. = - \left| \downarrow \right. ,
$$

we rearrange the charge conjugation term as

$$
c \bar { \psi } ^ { \dagger } \tau _ { 2 } ( \pmb { \rho } \cdot \pmb { \tau } ) ^ { T } \tau _ { 2 } \bar { \psi } = - c \bar { \psi } ^ { \dagger } ( \pmb { \rho } \cdot \pmb { \tau } ) \bar { \psi }
$$

where $\psi = ( d , - \bar { u } ) ^ { T } = i \tau _ { 2 } \psi ^ { \prime }$ . Now we are ready to calculate the isospin factors for $q q$ and $q q$ interactions via the

isovector meson exchange. Explicitly, they are given by

$$
\begin{array} { l } { { V _ { q q } \propto \pmb { \tau _ { 1 } } \cdot \pmb { \tau _ { 2 } } = \left\{ \begin{array} { l l } { { 1 } } & { { \mathrm { f o r } \ I = 1 } } \\ { { - 3 } } & { { \mathrm { f o r } \ I = 0 } } \end{array} \right. , } } \\ { { V _ { q \bar { q } } = - c V _ { q q } . } } \end{array}
$$

[1] M. Gell-Mann, Phys. Lett. 8, 214 (1964). [2] G. Zweig, “An SU(3) model for strong interaction symmetry and its breaking. Version 2,” in DEVELOPMENTS IN THE QUARK THEORY OF HADRONS. VOL. 1. 1964 - 1978, edited by D. B. Lichtenberg and S. P. Rosen (1964) pp. 22–101. [3] S. Godfrey and N. Isgur, Phys. Rev. D 32, 189 (1985).   
[4] S. Capstick and N. Isgur, AIP Conf. Proc. 132, 267 (1985).   
[5] S. K. Choi et al. (Belle), Phys. Rev. Lett. 91, 262001 (2003), arXiv:hep-ex/0309032. [6] P. A. Zyla et al. (Particle Data Group), PTEP 2020, 083C01 (2020). [7] M. Ablikim et al. (BESIII), Phys. Rev. Lett. 110, 252001 (2013), arXiv:1303.5949 [hep-ex]. [8] Z. Q. Liu et al. (Belle), Phys. Rev. Lett. 110, 252002 (2013), [Erratum: Phys.Rev.Lett. 111, 019901 (2013)], arXiv:1304.0121 [hep-ex]. [9] M. Ablikim et al. (BESIII), Phys. Rev. Lett. 112, 022001 (2014), arXiv:1310.1163 [hep-ex].   
[10] M. Ablikim et al. (BESIII), Phys. Rev. Lett. 112, 132001 (2014), arXiv:1308.2760 [hep-ex].   
[11] M. Ablikim et al. (BESIII), Phys. Rev. Lett. 111, 242001 (2013), arXiv:1309.1896 [hep-ex].   
[12] A. Bondar et al. (Belle), Phys. Rev. Lett. 108, 122001 (2012), arXiv:1110.2251 [hep-ex].   
[13] A. Garmash et al. (Belle), Phys. Rev. Lett. 116, 212001 (2016), arXiv:1512.07419 [hep-ex].   
[14] M. Ablikim et al. (BESIII), Phys. Rev. Lett. 126, 102001 (2021), arXiv:2011.07855 [hep-ex].   
[15] R. Aaij et al. (LHCb), Phys. Rev. Lett. 122, 222001 (2019), arXiv:1904.03947 [hep-ex].   
[16] H.-X. Chen, W. Chen, X. Liu, and S.-L. Zhu, Phys. Rept. 639, 1 (2016), arXiv:1601.02092 [hep-ph].   
[17] A. Hosaka, T. Iijima, K. Miyabayashi, Y. Sakai, and S. Yasui, PTEP 2016, 062C01 (2016), arXiv:1603.09229 [hep-ph].   
[18] J.-M. Richard, Few Body Syst. 57, 1185 (2016), arXiv:1606.08593 [hep-ph].   
[19] R. F. Lebed, R. E. Mitchell, and E. S. Swanson, Prog. Part. Nucl. Phys. 93, 143 (2017), arXiv:1610.04528 [hep-ph].   
[20] A. Esposito, A. Pilloni, and A. D. Polosa, Phys. Rept. 668, 1 (2017), arXiv:1611.07920 [hep-ph].   
[21] F.-K. Guo, C. Hanhart, U.-G. Meißner, Q. Wang, Q. Zhao, and B.-S. Zou, Rev. Mod. Phys. 90, 015004 (2018), arXiv:1705.00141 [hep-ph].   
[22] A. Ali, J. S. Lange, and S. Stone, Prog. Part. Nucl. Phys. 97, 123 (2017), arXiv:1706.00610 [hep-ph].   
[23] S. L. Olsen, T. Skwarnicki, and D. Zieminska, Rev. Mod. Phys. 90, 015003 (2018), arXiv:1708.04012 [hepph].   
[24] W. Altmannshofer et al. (Belle-II), PTEP 2019, 123C01 (2019), [Erratum: PTEP 2020, 029201 (2020)], arXiv:1808.10567 [hep-ex].   
[25] Y. S. Kalashnikova and A. V. Nefediev, Phys. Usp. 62, 568 (2019), arXiv:1811.01324 [hep-ph].   
[26] A. Cerri et al., CERN Yellow Rep. Monogr. 7, 867 (2019), arXiv:1812.07638 [hep-ph].   
[27] Y.-R. Liu, H.-X. Chen, W. Chen, X. Liu, and S.- L. Zhu, Prog. Part. Nucl. Phys. 107, 237 (2019), arXiv:1903.11976 [hep-ph].   
[28] N. Brambilla, S. Eidelman, C. Hanhart, A. Nefediev, C.-P. Shen, C. E. Thomas, A. Vairo, and C.-Z. Yuan, Phys. Rept. 873, 1 (2020), arXiv:1907.07583 [hep-ex].   
[29] F.-K. Guo, X.-H. Liu, and S. Sakai, Prog. Part. Nucl. Phys. 112, 103757 (2020), arXiv:1912.07030 [hep-ph].   
[30] G. Yang, J. Ping, and J. Segovia, Symmetry 12, 1869 (2020), arXiv:2009.00238 [hep-ph].   
[31] P. G. Ortega and D. R. Entem, Symmetry 13, 279 (2021), arXiv:2012.10105 [hep-ph].   
[32] X.-K. Dong, F.-K. Guo, and B.-S. Zou, Progr. Phys. 41, 65 (2021), arXiv:2101.01021 [hep-ph].   
[33] S. Weinberg, Phys. Rev. 130, 776 (1963).   
[34] S. Weinberg, Phys. Rev. 131, 440 (1963).   
[35] S. Weinberg, Phys. Rev. 137, B672 (1965).   
[36] V. Baru, J. Haidenbauer, C. Hanhart, Y. Kalashnikova, and A. E. Kudryavtsev, Phys. Lett. B 586, 53 (2004), arXiv:hep-ph/0308129.   
[37] I. Matuschek, V. Baru, F.-K. Guo, and C. Hanhart, Eur. Phys. J. A 57, 101 (2021), arXiv:2007.05329 [hepph].   
[38] X.-K. Dong, F.-K. Guo, and B.-S. Zou, Phys. Rev. Lett. 126, 152001 (2021), arXiv:2011.14517 [hep-ph].   
[39] R. Aaij et al. (LHCb), (2021), arXiv:2109.01038 [hepex].   
[40] R. Aaij et al. (LHCb), (2021), arXiv:2109.01056 [hepex].   
[41] N. Li, Z.-F. Sun, X. Liu, and S.-L. Zhu, Chin. Phys. Lett. 38, 092001 (2021), arXiv:2107.13748 [hep-ph].   
[42] S. S. Agaev, K. Azizi, and H. Sundu, (2021), arXiv:2108.00188 [hep-ph].   
[43] X.-Z. Ling, M.-Z. Liu, L.-S. Geng, E. Wang, and J.-J. Xie, (2021), arXiv:2108.00947 [hep-ph].   
[44] L. Meng, G.-J. Wang, B. Wang, and S.-L. Zhu, Phys. Rev. D 104, 051502 (2021), arXiv:2107.14784 [hep-ph].   
[45] R. Chen, Q. Huang, X. Liu, and S.-L. Zhu, (2021), arXiv:2108.01911 [hep-ph].   
[46] A. Feijoo, W. H. Liang, and E. Oset, (2021), arXiv:2108.02730 [hep-ph].   
[47] M.-J. Yan and M. P. Valderrama, (2021), arXiv:2108.04785 [hep-ph].   
[48] F.-L. Wang and X. Liu, (2021), arXiv:2108.09925 [hepph].   
[49] Q. Xin and Z.-G. Wang, (2021), arXiv:2108.12597 [hepph].   
[50] S. Fleming, R. Hodges, and T. Mehen, (2021), arXiv:2109.02188 [hep-ph].   
[51] K. Azizi and U. Ozdem, (2021), ¨ arXiv:2109.02390 [hepph].   
[52] X. Chen, (2021), arXiv:2109.02828 [hep-ph].   
[53] H. Ren, F. Wu, and R. Zhu, (2021), arXiv:2109.02531 [hep-ph].   
[54] Y. Jin, S.-Y. Li, Y.-R. Liu, Q. Qin, Z.-G. Si, and F.-S. Yu, (2021), arXiv:2109.05678 [hep-ph].   
[55] M. B. Voloshin and M. A. Shifman, Sov. J. Nucl. Phys. 45, 292 (1987).   
[56] H. D. Politzer and M. B. Wise, Phys. Lett. B 208, 504 (1988).   
[57] H. D. Politzer and M. B. Wise, Phys. Lett. B 206, 681 (1988).   
[58] N. Isgur and M. B. Wise, Phys. Lett. B 237, 527 (1990).   
[59] N. Isgur and M. B. Wise, Phys. Lett. B 232, 113 (1989).   
[60] M. Neubert, Phys. Rept. 245, 259 (1994), arXiv:hepph/9306320.   
[61] A. V. Manohar and M. B. Wise, Heavy quark physics, Vol. 10 (2000).   
[62] M. B. Wise, Phys. Rev. D 45, R2188 (1992).   
[63] R. Casalbuoni, A. Deandrea, N. Di Bartolomeo, R. Gatto, F. Feruglio, and G. Nardulli, Phys. Lett. B 292, 371 (1992), arXiv:hep-ph/9209248.   
[64] R. Casalbuoni, A. Deandrea, N. Di Bartolomeo, R. Gatto, F. Feruglio, and G. Nardulli, Phys. Rept. 281, 145 (1997), arXiv:hep-ph/9605342.   
[65] B. Grinstein, E. E. Jenkins, A. V. Manohar, M. J. Savage, and M. B. Wise, Nucl. Phys. B 380, 369 (1992), arXiv:hep-ph/9204207.   
[66] A. F. Falk, Nucl. Phys. B 378, 79 (1992).   
[67] A. F. Falk and M. E. Luke, Phys. Lett. B 292, 119 (1992), arXiv:hep-ph/9206241.   
[68] T.-M. Yan, H.-Y. Cheng, C.-Y. Cheung, G.-L. Lin, Y. C. Lin, and H.-L. Yu, Phys. Rev. D 46, 1148 (1992), [Erratum: Phys.Rev.D 55, 5851 (1997)].   
[69] R. Casalbuoni, A. Deandrea, N. Di Bartolomeo, R. Gatto, F. Feruglio, and G. Nardulli, Phys. Lett. B 299, 139 (1993), arXiv:hep-ph/9211248.   
[70] Y.-R. Liu and M. Oka, Phys. Rev. D 85, 014015 (2012), arXiv:1103.4624 [hep-ph].   
[71] M. Bando, T. Kugo, S. Uehara, K. Yamawaki, and T. Yanagida, Phys. Rev. Lett. 54, 1215 (1985).   
[72] M. Bando, T. Kugo, and K. Yamawaki, Phys. Rept. 164, 217 (1988).   
[73] A. A. Filin, A. Romanov, V. Baru, C. Hanhart, Y. S. Kalashnikova, A. E. Kudryavtsev, U. G. Meißner, and A. V. Nefediev, Phys. Rev. Lett. 105, 019101 (2010), arXiv:1004.4789 [hep-ph].   
[74] F.-K. Guo and U.-G. Meißner, Phys. Rev. D 84, 014013 (2011), arXiv:1102.3536 [hep-ph].   
[75] F.-K. Guo, EPJ Web Conf. 202, 02001 (2019).   
[76] J. A. Oller and E. Oset, Nucl. Phys. A 620, 438 (1997), [Erratum: Nucl.Phys.A 652, 407–409 (1999)], arXiv:hep-ph/9702314.   
[77] C. Isola, M. Ladisa, G. Nardulli, and P. Santorelli, Phys. Rev. D 68, 114001 (2003), arXiv:hep-ph/0307367.   
[78] X.-K. Dong, Y.-H. Lin, and B.-S. Zou, Phys. Rev. D 101, 076003 (2020), arXiv:1910.14455 [hep-ph].   
[79] R. Chen, Z.-F. Sun, X. Liu, and S.-L. Zhu, Phys. Rev. D 100, 011502 (2019), arXiv:1903.11013 [hep-ph].   
[80] J.-J. Wu, R. Molina, E. Oset, and B. S. Zou, Phys. Rev. C 84, 015202 (2011), arXiv:1011.2399 [nucl-th].   
[81] M. J. G. Veltman, Diagrammatica: The Path to Feynman rules, Vol. 4 (Cambridge University Press, 2012).   
[82] E. Epelbaum, H.-W. Hammer, and U.-G. Meißner, Rev. Mod. Phys. 81, 1773 (2009), arXiv:0811.1338 [nucl-th].   
[83] J. Nieves and M. P. Valderrama, Phys. Rev. D 86, 056004 (2012), arXiv:1204.2790 [hep-ph].   
[84] F.-K. Guo, C. Hidalgo-Duque, J. Nieves, and M. P. Valderrama, Phys. Rev. D 88, 054007 (2013), arXiv:1303.6608 [hep-ph].   
[85] C.-W. Shen, D. R¨onchen, U.-G. Meißner, and B.-S. Zou, Chin. Phys. C 42, 023106 (2018), arXiv:1710.03885 [hep-ph].   
[86] L. Meng, B. Wang, and S.-L. Zhu, Phys. Rev. D 102, 111502 (2020), arXiv:2011.08656 [hep-ph].   
[87] X. L. Wang et al. (Belle), (2021), arXiv:2105.06605 [hep-ex].   
[88] N. A. Tornqvist, Z. Phys. C 61, 525 (1994), arXiv:hepph/9310247.   
[89] R. Molina and E. Oset, Phys. Rev. D 80, 114013 (2009), arXiv:0907.3043 [hep-ph].   
[90] M. Albaladejo, F. K. Guo, C. Hidalgo-Duque, J. Nieves, and M. P. Valderrama, Eur. Phys. J. C 75, 547 (2015), arXiv:1504.00861 [hep-ph].   
[91] V. Baru, E. Epelbaum, A. A. Filin, C. Hanhart, U.-G. Meißner, and A. V. Nefediev, Phys. Lett. B 763, 20 (2016), arXiv:1605.09649 [hep-ph].   
[92] Y.-J. Zhang, H.-C. Chiang, P.-N. Shen, and B.-S. Zou, Phys. Rev. D 74, 014013 (2006), arXiv:hep-ph/0604271.   
[93] D. Gamermann, E. Oset, D. Strottman, and M. J. Vicente Vacas, Phys. Rev. D 76, 074016 (2007), arXiv:hepph/0612179.   
[94] X. Liu, Z.-G. Luo, Y.-R. Liu, and S.-L. Zhu, Eur. Phys. J. C 61, 411 (2009), arXiv:0808.0073 [hep-ph].   
[95] C.-Y. Wong, Phys. Rev. C 69, 055202 (2004), arXiv:hep-ph/0311088. [96] C. Hidalgo-Duque, J. Nieves, and M. P. Valderrama, Phys. Rev. D 87, 076006 (2013), arXiv:1210.5431 [hepph]. [97] S. Prelovsek, S. Collins, D. Mohler, M. Padmanath, and S. Piemonte, JHEP 06, 035 (2021), arXiv:2011.02542 [hep-lat]. [98] R. Aaij et al. (LHCb), Phys. Rev. D 102, 092005 (2020), arXiv:2005.13419 [hep-ex]. [99] D. Janc and M. Rosina, Few Body Syst. 35, 175 (2004), arXiv:hep-ph/0405208.   
[100] S. Ohkoda, Y. Yamaguchi, S. Yasui, K. Sudoh, and A. Hosaka, Phys. Rev. D 86, 034019 (2012), arXiv:1202.0760 [hep-ph].   
[101] N. Li, Z.-F. Sun, X. Liu, and S.-L. Zhu, Phys. Rev. D 88, 114008 (2013), arXiv:1211.5007 [hep-ph].   
[102] M.-Z. Liu, T.-W. Wu, M. Pavon Valderrama, J.-J. Xie, and L.-S. Geng, Phys. Rev. D 99, 094018 (2019), arXiv:1902.03044 [hep-ph].   
[103] M.-Z. Liu, J.-J. Xie, and L.-S. Geng, Phys. Rev. D 102, 091502 (2020), arXiv:2008.07389 [hep-ph].   
[104] Y. Yang, C. Deng, J. Ping, and T. Goldman, Phys. Rev. D 80, 114023 (2009).   
[105] J. Carlson, L. Heller, and J. A. Tjon, Phys. Rev. D 37, 744 (1988).   
[106] B. Silvestre-Brac and C. Semay, Z. Phys. C 57, 273 (1993).   
[107] B. Silvestre-Brac and C. Semay, Z. Phys. C 59, 457 (1993).   
[108] C. Semay and B. Silvestre-Brac, Z. Phys. C 61, 271 (1994).   
[109] B. A. Gelman and S. Nussinov, Phys. Lett. B 551, 296 (2003), arXiv:hep-ph/0209095.   
[110] J. Vijande, F. Fernandez, A. Valcarce, and B. SilvestreBrac, Eur. Phys. J. A 19, 383 (2004), arXiv:hepph/0310007.   
[111] F. S. Navarra, M. Nielsen, and S. H. Lee, Phys. Lett. B 649, 166 (2007), arXiv:hep-ph/0703071.   
[112] D. Ebert, R. N. Faustov, V. O. Galkin, and W. Lucha, Phys. Rev. D 76, 114015 (2007), arXiv:0706.3853 [hepph].   
[113] J. Vijande, E. Weissman, A. Valcarce, and N. Barnea, Phys. Rev. D 76, 094027 (2007), arXiv:0710.2516 [hepph].   
[114] S. H. Lee and S. Yasui, Eur. Phys. J. C 64, 283 (2009), arXiv:0901.2977 [hep-ph].   
[115] M. Abud, F. Buccella, and F. Tramontano, Phys. Rev. D 81, 074018 (2010), arXiv:0912.4299 [hep-ph].   
[116] M. Karliner and S. Nussinov, JHEP 07, 153 (2013), arXiv:1304.0345 [hep-ph].   
[117] G. Q. Feng, X. H. Guo, and B. S. Zou, (2013), arXiv:1309.7813 [hep-ph].   
[118] S.-Q. Luo, K. Chen, X. Liu, Y.-R. Liu, and S.-L. Zhu, Eur. Phys. J. C 77, 709 (2017), arXiv:1707.01180 [hepph].   
[119] M. Karliner and J. L. Rosner, Phys. Rev. Lett. 119, 202001 (2017), arXiv:1707.07666 [hep-ph].   
[120] E. J. Eichten and C. Quigg, Phys. Rev. Lett. 119, 202002 (2017), arXiv:1707.09575 [hep-ph].   
[121] Z.-G. Wang, Acta Phys. Polon. B 49, 1781 (2018), arXiv:1708.04545 [hep-ph].   
[122] T. Hyodo, Y.-R. Liu, M. Oka, and S. Yasui, (2017), arXiv:1708.05169 [hep-ph].   
[123] G. K. C. Cheung, C. E. Thomas, J. J. Dudek, and R. G. Edwards (Hadron Spectrum), JHEP 11, 033 (2017), arXiv:1709.01417 [hep-lat].   
[124] W. Park, S. Noh, and S. H. Lee, Nucl. Phys. A 983, 1 (2019), arXiv:1809.05257 [nucl-th].   
[125] P. Junnarkar, N. Mathur, and M. Padmanath, Phys. Rev. D 99, 034507 (2019), arXiv:1810.12285 [hep-lat].   
[126] C. Deng, H. Chen, and J. Ping, Eur. Phys. J. A 56, 9 (2020), arXiv:1811.06462 [hep-ph].   
[127] G. Yang, J. Ping, and J. Segovia, Phys. Rev. D 101, 014001 (2020), arXiv:1911.00215 [hep-ph].   
[128] Y. Tan, W. Lu, and J. Ping, Eur. Phys. J. Plus 135, 716 (2020), arXiv:2004.02106 [hep-ph].   
[129] Q.-F. L¨u, D.-Y. Chen, and Y.-B. Dong, Phys. Rev. D 102, 034012 (2020), arXiv:2006.08087 [hep-ph].   
[130] E. Braaten, L.-P. He, and A. Mohapatra, Phys. Rev. D 103, 016001 (2021), arXiv:2006.08650 [hep-ph].   
[131] D. Gao, D. Jia, Y.-J. Sun, Z. Zhang, W.-N. Liu, and Q. Mei, (2020), arXiv:2007.15213 [hep-ph].   
[132] J.-B. Cheng, S.-Y. Li, Y.-R. Liu, Z.-G. Si, and T. Yao, Chin. Phys. C 45, 043102 (2021), arXiv:2008.00737 [hep-ph].   
[133] S. Noh, W. Park, and S. H. Lee, Phys. Rev. D 103, 114009 (2021), arXiv:2102.09614 [hep-ph].   
[134] R. N. Faustov, V. O. Galkin, and E. M. Savchenko, Universe 7, 94 (2021), arXiv:2103.01763 [hep-ph].   
[135] D. G. Richards, D. K. Sinclair, and D. W. Sivers, Phys. Rev. D 42, 3191 (1990).   
[136] A. V. Manohar and M. B. Wise, Nucl. Phys. B 399, 17 (1993), arXiv:hep-ph/9212236.   
[137] A. Mihaly, H. R. Fiebig, H. Markum, and K. Rabitsch, Phys. Rev. D 55, 3077 (1997).   
[138] C. Stewart and R. Koniuk, Phys. Rev. D 57, 5581 (1998), arXiv:hep-lat/9803003.   
[139] T. Barnes, N. Black, D. J. Dean, and E. S. Swanson, Phys. Rev. C 60, 045202 (1999), arXiv:nucl-th/9902068.   
[140] R. Molina, T. Branz, and E. Oset, Phys. Rev. D 82, 014010 (2010), arXiv:1005.0335 [hep-ph].   
[141] T. F. Carames, A. Valcarce, and J. Vijande, Phys. Lett. B 699, 291 (2011).   
[142] Z.-F. Sun, X. Liu, M. Nielsen, and S.-L. Zhu, Phys. Rev. D 85, 094008 (2012), arXiv:1203.1090 [hep-ph].   
[143] H. Xu, B. Wang, Z.-W. Liu, and X. Liu, Phys. Rev. D 99, 014027 (2019), arXiv:1708.06918 [hep-ph].   
[144] T. F. Caram´es, J. Vijande, and A. Valcarce, Phys. Rev. D 99, 014006 (2019), arXiv:1812.08991 [hep-ph].   
[145] C. Michael and P. Pennanen (UKQCD), Phys. Rev. D 60, 054012 (1999), arXiv:hep-lat/9901007.   
[146] P. Pennanen, C. Michael, and A. M. Green (UKQCD), Nucl. Phys. B Proc. Suppl. 83, 200 (2000), arXiv:heplat/9908032.   
[147] M. Wagner (ETM), Acta Phys. Polon. Supp. 4, 747 (2011), arXiv:1103.5147 [hep-lat].   
[148] A. L. Guerrieri, M. Papinutto, A. Pilloni, A. D. Polosa, and N. Tantalo, PoS LATTICE2014, 106 (2015), arXiv:1411.2247 [hep-lat].   
[149] Y. Ikeda, B. Charron, S. Aoki, T. Doi, T. Hatsuda, T. Inoue, N. Ishii, K. Murano, H. Nemura, and K. Sasaki, Phys. Lett. B 729, 85 (2014), arXiv:1311.6214 [hep-lat].   
[150] W. Detmold, K. Orginos, and M. J. Savage, Phys. Rev. D 76, 114503 (2007), arXiv:hep-lat/0703009.   
[151] G. Bali and M. Hetzenegger (QCDSF), PoS LATTICE2011, 123 (2011), arXiv:1111.2222 [hep-lat].   
[152] Z. S. Brown and K. Orginos, Phys. Rev. D 86, 114506 (2012), arXiv:1210.1953 [hep-lat].   
[153] P. Bicudo and M. Wagner (European Twisted Mass), Phys. Rev. D 87, 114511 (2013), arXiv:1209.6274 [hepph].   
[154] P. Bicudo, K. Cichy, A. Peters, B. Wagenbach, and M. Wagner, Phys. Rev. D 92, 014507 (2015), arXiv:1505.00613 [hep-lat].   
[155] P. Bicudo, K. Cichy, A. Peters, and M. Wagner, Phys. Rev. D 93, 034501 (2016), arXiv:1510.03441 [hep-lat].   
[156] P. Bicudo, J. Scheunert, and M. Wagner, Phys. Rev. D 95, 034502 (2017), arXiv:1612.02758 [hep-lat].   
[157] M. Karliner and J. L. Rosner, Phys. Rev. Lett. 115, 122001 (2015), arXiv:1506.06386 [hep-ph].   
[158] M. Sanchez Sanchez, L.-S. Geng, J.-X. Lu, T. Hyodo, and M. P. Valderrama, Phys. Rev. D 98, 054001 (2018), arXiv:1707.03802 [hep-ph].   
[159] S. Sakai, L. Roca, and E. Oset, Phys. Rev. D 96, 054023 (2017), arXiv:1704.02196 [hep-ph].   
[160] B. Wang, Z.-W. Liu, and X. Liu, Phys. Rev. D 99, 036007 (2019), arXiv:1812.04457 [hep-ph].   
[161] M.-T. Yu, Z.-Y. Zhou, D.-Y. Chen, and Z. Xiao, Phys. Rev. D 101, 074027 (2020), arXiv:1912.07348 [hep-ph].   
[162] Z.-M. Ding, H.-Y. Jiang, and J. He, Eur. Phys. J. C 80, 1179 (2020), arXiv:2011.04980 [hep-ph].   
[163] Q. Meng, E. Hiyama, A. Hosaka, M. Oka, P. Gubler, K. U. Can, T. T. Takahashi, and H. S. Zong, Phys. Lett. B 814, 136095 (2021), arXiv:2009.14493 [nucl-th].   
[164] Z.-M. Ding, H.-Y. Jiang, D. Song, and J. He, Eur. Phys. J. C 81, 732 (2021), arXiv:2107.00855 [hep-ph].   
[165] P. Bicudo, A. Peters, S. Velten, and M. Wagner, Phys. Rev. D 103, 114506 (2021), arXiv:2101.00723 [hep-lat].   
[166] J. P. Ader, J. M. Richard, and P. Taxil, Phys. Rev. D 25, 2370 (1982).   
[167] J. l. Ballot and J. M. Richard, Phys. Lett. B 123, 449 (1983).   
[168] S. Zouzou, B. Silvestre-Brac, C. Gignoux, and J. M. Richard, Z. Phys. C 30, 457 (1986).   
[169] L. Heller and J. A. Tjon, Phys. Rev. D 35, 969 (1987).   
[170] D. M. Brink and F. Stancu, Phys. Rev. D 57, 6778 (1998).   
[171] J. Schaffner-Bielich and A. P. Vischer, Phys. Rev. D 57, 4142 (1998), arXiv:nucl-th/9710064.   
[172] A. Czarnecki, B. Leng, and M. B. Voloshin, Phys. Lett. B 778, 233 (2018), arXiv:1708.04594 [hep-ph].   
[173] J. Vijande, A. Valcarce, and N. Barnea, Phys. Rev. D 79, 074010 (2009), arXiv:0903.2949 [hep-ph].   
[174] T. Hyodo, Y.-R. Liu, M. Oka, K. Sudoh, and S. Yasui, Phys. Lett. B 721, 56 (2013), arXiv:1209.6207 [hep-ph].   
[175] Y. Xing and R. Zhu, Phys. Rev. D 98, 053005 (2018), arXiv:1806.01659 [hep-ph].   
[176] Y. Cui, X.-L. Chen, W.-Z. Deng, and S.-L. Zhu, HEPNP 31, 7 (2007), arXiv:hep-ph/0607226.   
[177] B. Silvestre-Brac, Phys. Rev. D 46, 2179 (1992).   
[178] Q. Meng, M. Harada, E. Hiyama, A. Hosaka, and M. Oka, (2021), arXiv:2106.11868 [hep-ph].   
[179] Z.-G. Wang, Y.-M. Xu, and H.-J. Wang, Commun. Theor. Phys. 55, 1049 (2011), arXiv:1004.0484 [hep-ph].   
[180] J. M. Dias, S. Narison, F. S. Navarra, M. Nielsen, and J. M. Richard, Phys. Lett. B 703, 274 (2011), arXiv:1105.5630 [hep-ph].   
[181] W. Chen, T. G. Steele, and S.-L. Zhu, Phys. Rev. D 89, 054037 (2014), arXiv:1310.8337 [hep-ph].   
[182] Z.-G. Wang and Z.-H. Yan, Eur. Phys. J. C 78, 19 (2018), arXiv:1710.02810 [hep-ph].   
[183] Q.-N. Wang and W. Chen, Eur. Phys. J. C 80, 389 (2020), arXiv:2002.04243 [hep-ph].   
[184] S. S. Agaev, K. Azizi, B. Barsbay, and H. Sundu, Phys. Rev. D 99, 033002 (2019), arXiv:1809.07791 [hep-ph].   
[185] L. Tang, B.-D. Wan, K. Maltman, and C.-F. Qiao, Phys. Rev. D 101, 094032 (2020), arXiv:1911.10951 [hep-ph].   
[186] S. S. Agaev, K. Azizi, and H. Sundu, Nucl. Phys. B 951, 114890 (2020), arXiv:1905.07591 [hep-ph].   
[187] S. S. Agaev, K. Azizi, B. Barsbay, and H. Sundu, Phys. Rev. D 101, 094026 (2020), arXiv:1912.07656 [hep-ph].   
[188] S. S. Agaev, K. Azizi, B. Barsbay, and H. Sundu, Chin. Phys. C 45, 013105 (2021), arXiv:2002.04553 [hep-ph].   
[189] A. M. Green and P. Pennanen, Phys. Rev. C 57, 3384 (1998), arXiv:hep-lat/9804003.   
[190] A. Francis, R. J. Hudspith, R. Lewis, and K. Maltman, Phys. Rev. Lett. 118, 142001 (2017), arXiv:1607.05214 [hep-lat].   
[191] L. Leskovec, S. Meinel, M. Pflaumer, and M. Wagner, Phys. Rev. D 100, 014503 (2019), arXiv:1904.04197 [hep-lat].   
[192] R. J. Hudspith, B. Colquhoun, A. Francis, R. Lewis, and K. Maltman, Phys. Rev. D 102, 114506 (2020), arXiv:2006.14294 [hep-lat].   
[193] A. Francis, R. J. Hudspith, R. Lewis, and K. Maltman, Phys. Rev. D 99, 054505 (2019), arXiv:1810.10550 [heplat].   
[194] P. Mohanta and S. Basak, Phys. Rev. D 102, 094516 (2020), arXiv:2008.11146 [hep-lat].   
[195] A. Valcarce, J. Vijande, and T. F. Carames, Int. J. Mod. Phys. Conf. Ser. 2, 173 (2011), arXiv:1012.4627 [hep-ph].   
[196] S. Pepin, F. Stancu, M. Genovese, and J. M. Richard, Phys. Lett. B 393, 119 (1997), arXiv:hep-ph/9609348.   
[197] J.-M. Richard, A. Valcarce, and J. Vijande, Phys. Rev. C 97, 035211 (2018), arXiv:1803.06155 [hep-ph].   
[198] M. Zhang, H. X. Zhang, and Z. Y. Zhang, Commun. Theor. Phys. 50, 437 (2008), arXiv:0711.1029 [nucl-th].   
[199] H. J. Lipkin, Phys. Lett. B 172, 242 (1986).   
[200] R. Aaij et al. (LHCb), Phys. Rev. Lett. 119, 112001 (2017), arXiv:1707.01621 [hep-ex].   
[201] M. J. Savage and M. B. Wise, Phys. Lett. B 248, 177 (1990).   
[202] E. Eichten, Nucl. Phys. B Proc. Suppl. 4, 170 (1988).   
[203] G. P. Lepage and B. A. Thacker, Nucl. Phys. B Proc. Suppl. 4, 199 (1988).   
[204] M. Karliner and J. L. Rosner, Phys. Rev. D 90, 094007 (2014), arXiv:1408.5877 [hep-ph].   
[205] T. Mehen, Phys. Rev. D 96, 094028 (2017), arXiv:1708.05020 [hep-ph].   
[206] P. Bicudo, M. Cardoso, A. Peters, M. Pflaumer, and M. Wagner, Phys. Rev. D 96, 054510 (2017), arXiv:1704.02383 [hep-lat].   
[207] J.-J. Wu, R. Molina, E. Oset, and B. S. Zou, Phys. Rev. Lett. 105, 232001 (2010), arXiv:1007.0573 [nucl-th].   
[208] J. M. Dias, V. R. Debastiani, J. J. Xie, and E. Oset, Phys. Rev. D 98, 094017 (2018), arXiv:1805.03286 [hepph].   
[209] Q.-X. Yu, J. M. Dias, W.-H. Liang, and E. Oset, Eur. Phys. J. C 79, 1025 (2019), arXiv:1909.13449 [hep-ph].   
[210] J. M. Dias, Q.-X. Yu, W.-H. Liang, Z.-F. Sun, J.-J. Xie, and E. Oset, Chin. Phys. C 44, 064101 (2020), arXiv:1912.04517 [hep-ph].   
[211] Y. Shimizu and M. Harada, Phys. Rev. D 96, 094012 (2017), arXiv:1708.04743 [hep-ph].   
[212] Z.-H. Guo, Phys. Rev. D 96, 074004 (2017), arXiv:1708.04145 [hep-ph].   
[213] M.-J. Yan, X.-H. Liu, S. Gonz\`alez-Sol´ıs, F.-K. Guo, C. Hanhart, U.-G. Meißner, and B.-S. Zou, Phys. Rev. D 98, 091502 (2018), arXiv:1805.10972 [hep-ph].   
[214] Q. Xu, G. Liu, and H. Jin, Phys. Rev. D 86, 114032 (2012), arXiv:1012.5949 [hep-ph].   
[215] R. Chen, A. Hosaka, and X. Liu, Phys. Rev. D 96, 116012 (2017), arXiv:1707.08306 [hep-ph].   
[216] K. Chen, B. Wang, and S.-L. Zhu, Phys. Rev. D 103, 116017 (2021), arXiv:2102.05868 [hep-ph].   
[217] Q.-S. Zhou, K. Chen, X. Liu, Y.-R. Liu, and S.-L. Zhu, Phys. Rev. C 98, 045204 (2018), arXiv:1801.04557 [hepph].   
[218] R. Zhu, X. Liu, H. Huang, and C.-F. Qiao, Phys. Lett. B 797, 134869 (2019), arXiv:1904.10285 [hep-ph].   
[219] Y. Xing and Y. Niu, (2021), arXiv:2106.09939 [hep-ph].   
[220] Z.-G. Wang, Eur. Phys. J. C 78, 826 (2018), arXiv:1808.09820 [hep-ph].   
[221] W. Park, S. Cho, and S. H. Lee, Phys. Rev. D 99, 094023 (2019), arXiv:1811.10911 [hep-ph].   
[222] N. Lee, Z.-G. Luo, X.-L. Chen, and S.-L. Zhu, Phys. Rev. D 84, 014031 (2011), arXiv:1104.4257 [hep-ph].   
[223] W. Meguro, Y.-R. Liu, and M. Oka, Phys. Lett. B 704, 547 (2011), arXiv:1105.3693 [hep-ph].   
[224] H. Huang, J. Ping, and F. Wang, Phys. Rev. C 89, 035201 (2014), arXiv:1311.4732 [hep-ph].   
[225] M. Oka, Nucl. Phys. A 914, 447 (2013).   
[226] T. F. Carames and A. Valcarce, Phys. Rev. D 92, 034015 (2015), arXiv:1507.08278 [hep-ph].   
[227] H. Garcilazo and A. Valcarce, Eur. Phys. J. C 80, 720 (2020), arXiv:2008.00675 [hep-ph].   
[228] N. Li and S.-L. Zhu, Phys. Rev. D 86, 014020 (2012), arXiv:1204.3364 [hep-ph].   
[229] X.-W. Wang, Z.-G. Wang, and G.-l. Yu, Eur. Phys. J. A 57, 275 (2021), arXiv:2107.04751 [hep-ph].   
[230] S. M. Gerasyuta and E. E. Matskevich, Int. J. Mod. Phys. E 21, 1250058 (2012), arXiv:1109.2338 [hep-ph].   
[231] J.-X. Lu, L.-S. Geng, and M. P. Valderrama, Phys. Rev. D 99, 074026 (2019), arXiv:1706.02588 [hep-ph].   
[232] F. Froemel, B. Julia-Diaz, and D. O. Riska, Nucl. Phys. A 750, 337 (2005), arXiv:nucl-th/0410034.   
[233] B. Yang, L. Meng, and S.-L. Zhu, Eur. Phys. J. A 55, 21 (2019), arXiv:1810.03332 [hep-ph].   
[234] J. Vijande, A. Valcarce, J. M. Richard, and P. Sorba, Phys. Rev. D 94, 034038 (2016), arXiv:1608.03982 [hepph].   
[235] E. E. Kolomeitsev and M. F. M. Lutz, Phys. Lett. B 582, 39 (2004), arXiv:hep-ph/0307133.   
[236] F.-K. Guo, P.-N. Shen, H.-C. Chiang, R.-G. Ping, and B.-S. Zou, Phys. Lett. B 641, 278 (2006), arXiv:hepph/0603072.

TABLE VII. The group theory factor $F ^ { \prime }$ , defined in Eq. (13), for the interaction of charm-anticharm/charm-charm hadron pairs with only the light vector-meson exchanges. Here both charm hadrons are the $S$ -wave ground states. $I$ is the isospin and $S$ is the strangeness. Note that we have collect the pairs with the heavy hadrons in the same spin multiples (such as $\cal D $ , $D D ^ { * }$ , etc.) in one row, and the several numbers in the column of “Thresholds” represent the thresholds of these different pairs in an increasing order. Positive $F ^ { \prime }$ means that the interaction attractive. The values in the column of “ $F$ ” correspond to those for   

<html><body><table><tr><td colspan="6">the exchanged particles in the columnof “Exchanged particles”in order.</td></tr><tr><td>System</td><td>I</td><td>S</td><td>Thresholds [MeV]</td><td> Exchanged particles</td><td>F</td></tr><tr><td>D（*）D（*）/D（*)D(*)</td><td>1</td><td>0/0</td><td>(3734,3876, 4017)</td><td>p,W</td><td>/， 1</td></tr><tr><td>D（*）D（*）/D（*）D（*）</td><td>0 1-2</td><td>1/1</td><td>(3836,3977,3979,4121)</td><td>K*</td><td>2 0/-1</td></tr><tr><td>D（）D（）/D（）D（）</td><td>0</td><td>0/2</td><td>(3937,4081,4224)</td><td></td><td>1/-1</td></tr><tr><td>D（）Ac/D（）Ac</td><td>1-2</td><td>0/0</td><td>(4154,4295)</td><td>W</td><td>-1/1</td></tr><tr><td>D）Ac/D）Ac</td><td>0</td><td>-1/1</td><td>(4255,4399)</td><td>1</td><td>0/0</td></tr><tr><td>D（*）三c/D（*）三c</td><td>1</td><td>-1/-1</td><td>(4337,4478)</td><td>p,W</td><td>123-2</td></tr><tr><td>D（*）Ec/D*）三c</td><td>0 1-2</td><td>-2/0</td><td>(4438,4582)</td><td></td><td>/ -1/1 /</td></tr><tr><td>D（）Ω（/D（）Ω（*）</td><td>3-21-2</td><td>0/0</td><td>(4321, 4385,4462,4527)</td><td>p,w</td><td>−1,−1/-1,1</td></tr><tr><td>D（）Ω（）/D（）Ω（*）</td><td>1</td><td>-1/1</td><td>(4422,4486,4566, 4630)</td><td></td><td>2,-1/2,1 0/0</td></tr><tr><td>D（*）=（*）/D（*）=（*）</td><td>1</td><td>-1/-1</td><td>(4446,4513,4587,4655)</td><td>1 p,W</td><td>1/</td></tr><tr><td></td><td>0</td><td></td><td></td><td></td><td>1-23-2 /</td></tr><tr><td>D（）=（*）/D（*）=（*）</td><td>1-2</td><td>-2/0</td><td>(4547,4614,4691, 4758)</td><td></td><td>-1/1</td></tr><tr><td>D（*）Ω（*）/D（*）Ω2（*）</td><td>1-2</td><td>-2/0</td><td>(4562, 4633, 4704, 4774)</td><td></td><td>0/0</td></tr><tr><td>D（）（）/D（）Ω（*）</td><td></td><td></td><td></td><td>1</td><td></td></tr><tr><td></td><td>0</td><td>-3/-1</td><td>(4664,4734,4807,4878)</td><td>?</td><td>-2/2</td></tr><tr><td>AcAc/AcAc Ac/AE</td><td>0</td><td>0/0</td><td>(4573)</td><td></td><td>2/-2</td></tr><tr><td>三三c/三三</td><td>1-2</td><td>1/-1</td><td>(4756)</td><td>w/K*</td><td>1,0/-1,−1</td></tr><tr><td></td><td>1 0</td><td>0/-2</td><td>(4939)</td><td>p,w，</td><td>2，1 ，-1</td></tr><tr><td>AE（/A（</td><td>1</td><td>0/0</td><td>(4740,4805)</td><td>w/K*</td><td>1,0/-1,-1</td></tr><tr><td>A（）/三（*）</td><td>1-2</td><td>1/-1</td><td>(4865,4932)</td><td></td><td>1/-1</td></tr><tr><td>A(*）/A（*）</td><td>0</td><td>2/-2</td><td>(4982,5052)</td><td></td><td>0/0</td></tr><tr><td>）/）</td><td></td><td>1/-1</td><td>(4923,4988)</td><td>p,w,K*</td><td>−1,1,0/ − 1,−1, -2</td></tr><tr><td></td><td>3-21-2</td><td></td><td></td><td></td><td>2,1,0/2,−1,-2</td></tr><tr><td>三（*）/三三（*）</td><td>1 0</td><td>0/-2</td><td>(5048,5115)</td><td>p,w,</td><td>1/</td></tr><tr><td>三S2（*）/三2（*）</td><td>1-2</td><td>1/-3</td><td>(5165,5235)</td><td>,K*</td><td>2,0/-2,-2</td></tr><tr><td>/</td><td>2 1</td><td>0/0</td><td>(4907,4972, 5036)</td><td>p,w</td><td>-2,2/-2,-2 2,2/2,-2</td></tr><tr><td></td><td>0</td><td></td><td></td><td></td><td>4,2/4,-2</td></tr><tr><td></td><td> 3-21-2</td><td>1/-1</td><td>(5032,5097,5100, 5164)</td><td>p,w,K*</td><td>−1,1,0/-1,−1 − 2 2,1,0/2,−1,-2</td></tr><tr><td>Ω（*）(）/（*）2（*）</td><td>0</td><td>2/-2</td><td>(5149,5213, 5219, 5284)</td><td></td><td>0/0</td></tr><tr><td>（*）（）/（）=（）</td><td></td><td></td><td></td><td>一</td><td></td></tr><tr><td></td><td>１０</td><td>0/-2</td><td>(5158,5225,5292)</td><td>p,w,</td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>（*）（）/=（*）Ω（*） 2）（）/52）</td><td>1-2</td><td>1/-3 0/-4</td><td>(5272,5341, 5345, 5412)</td><td>,K*</td><td>2,0/-2,-2</td></tr></table></body></html>

TABLE VIII. The group theory factor $F ^ { \prime }$ , defined in Eq. (13), for the interaction of charm-anticharm/charm-charm hadron pairs with only the light vector-meson exchanges. Here one of the charm hadrons is an $s _ { \ell } = 3 / 2$ charm meson. See the caption of Table VII.   

<html><body><table><tr><td>System</td><td>I</td><td>S</td><td>Thresholds [MeV]</td><td>Exchanged particles</td><td>F</td></tr><tr><td>D）D1,2/D（*）D1,2</td><td>0</td><td>0/0</td><td>(4289,4330, 4431, 4472)</td><td>p,w</td><td>2/ 1-2 1 ，</td></tr><tr><td></td><td>1</td><td>0/0</td><td></td><td></td><td>1-2</td></tr><tr><td>D(*)Ds1,s2/D(*) Ds1,s2</td><td>1-2:</td><td>1/-1</td><td>(4390, 4431, 4534, 4575)</td><td></td><td>0/0</td></tr><tr><td>D）D1,2/D）D12</td><td>1-2</td><td>-1/1</td><td>(4402, 4436, 4544, 4578)</td><td></td><td>0/0</td></tr><tr><td>D）Ds1,s2/D）Ds1,52</td><td>0</td><td>0/-2</td><td>(4503,4537,4647, 4681)</td><td></td><td>1/-1</td></tr><tr><td>D1,2D1,2/D1,2D1,2</td><td>0</td><td>0/0</td><td>(4844, 4885,4926)</td><td>p,W</td><td>/，</td></tr><tr><td>Ds1,s2D1,2/Ds1,s2D1,2</td><td>1 1-2</td><td>1/1</td><td>(4957,4991,4998, 5032)</td><td></td><td>/， 0/0</td></tr><tr><td>Ds1,s2Ds1,s2/Ds1,s2Ds1,s2</td><td>0</td><td>0/-2</td><td>(5070,5104,5138)</td><td></td><td>1/1</td></tr><tr><td>AcD1,2/AcD1,2</td><td>1-2</td><td>0/0</td><td>(4708,4750)</td><td></td><td>-1/1</td></tr><tr><td>AcDs1,s2/AcDs1,s2</td><td>0</td><td>-1/1</td><td>(4822,4856)</td><td>W</td><td>0/0</td></tr><tr><td>ED1,2/三D1,2</td><td>1</td><td>-1/-1</td><td>(4891,4932)</td><td>1 p,w</td><td>/</td></tr><tr><td></td><td>0</td><td></td><td></td><td></td><td>123-2 /</td></tr><tr><td>三cDs1,s2/EcDs1,s2 D1,2/D1,2</td><td>1-2</td><td>-2/0</td><td>(5005,5039)</td><td></td><td>-1/1</td></tr><tr><td></td><td>3-21 1-2</td><td>0/0</td><td>(4876, 4917, 4940, 4981)</td><td>p,w</td><td>−1,−1/-1,1 2,-1/2,1</td></tr><tr><td></td><td>１１</td><td>1/-1</td><td>(5001,502,5053.508)</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>()Ds1,52/(）D1.82</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>0）D12/0） D1.2</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>01-2</td><td>-2/0</td><td>(5114, 5148, 5181, 5215)</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td>(5117, 5158, 5188, 5229)</td><td></td><td></td></tr><tr><td></td><td>1-2</td><td></td><td></td><td></td><td>0/0</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td>-2/-2</td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>）Ds1,s2/）Ds1,s2</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>0</td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td>(5230,5264,5301, 5335)</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td>?</td><td>-2/2</td></tr><tr><td></td><td></td><td>-3/-1</td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr></table></body></html>

TABLE IX. The group theory factor $F ^ { \prime }$ , defined in Eq. (13), for the interaction of bottom-antibottom/bottom-bottom hadron pairs with only the light vector-meson exchanges. Here both bottom hadrons are the $S$ -wave ground states. See the caption of   

<html><body><table><tr><td colspan="6">Table VII.</td></tr><tr><td>System</td><td>I</td><td>S</td><td>Thresholds [MeV]</td><td>Exchanged particles</td><td>F</td></tr><tr><td>B（*）B（*）/B（*）B（*）</td><td>1</td><td>0/0</td><td>(10559,10604,10649)</td><td>p,w</td><td>/-,</td></tr><tr><td>B（）B（*）/B（*）B（*）</td><td>0</td><td></td><td></td><td>K*</td><td>/，</td></tr><tr><td>B）B（）/B（）B）</td><td>1-2 0</td><td>1/1 0/2</td><td>(10646,10695,10692,10740) (10734,10782,10831)</td><td></td><td>0/-1 1/-1</td></tr><tr><td>B（）b/B（*）A</td><td>1-2</td><td>0/0</td><td>(10899,10944)</td><td></td><td>-1/1</td></tr><tr><td>B/B）Ab</td><td>0</td><td>-1/1</td><td>(10986,11035)</td><td></td><td>0/0</td></tr><tr><td>B（*）三6/B（*）三6</td><td>1</td><td>-1/-1</td><td>(11074,11119)</td><td>1 p,w</td><td>/</td></tr><tr><td></td><td>0</td><td></td><td></td><td></td><td>1232 /</td></tr><tr><td>B）=/B（）= B@Eg/B0</td><td>1-2</td><td>-2/0</td><td>(11161,11210)</td><td></td><td>-1/1</td></tr><tr><td></td><td>3-21-2</td><td>0/0</td><td>(11093,11138,11112,11157)</td><td>p,W</td><td>−1, −1/−1,1 2,-1/2,1</td></tr><tr><td></td><td>11</td><td>--1/11</td><td>(118,1</td><td></td><td></td></tr><tr><td></td><td>0</td><td></td><td></td><td></td><td>/-</td></tr><tr><td>B）（)/B(）（() b</td><td>1-21</td><td>-2/0</td><td>(11302,11350,11321,11369)</td><td></td><td>/ -1/1</td></tr><tr><td>B0g/B0</td><td>-1-2</td><td>-2/0</td><td>(11326,11371,11349,11395)</td><td></td><td>0/0</td></tr><tr><td>B））/B（）</td><td>0</td><td>-3/-1</td><td>(11413,11462,11437,11485)</td><td>1</td><td></td></tr><tr><td>AbAb/AbAb</td><td>0</td><td>0/0</td><td>(11239)</td><td></td><td>-2/2</td></tr><tr><td>A6三6/A6三6</td><td></td><td></td><td>(11414)</td><td></td><td>2/-2</td></tr><tr><td>三6三6/三6三6</td><td>1-2</td><td>1/-1 0/-2</td><td>(11589)</td><td>p,w, w,K*</td><td>1,0/-1,−1</td></tr><tr><td></td><td>１0</td><td></td><td></td><td></td><td></td></tr><tr><td>（*）</td><td>1</td><td>0/0</td><td>(11433,11452)</td><td></td><td>2/-2</td></tr><tr><td></td><td>1-2</td><td>1/-1</td><td>(11555,11573)</td><td>w,K*</td><td>1,0/-1,−1</td></tr><tr><td>△（*）/A62（*） 三/</td><td>0</td><td>2/-2</td><td>(11666,11690)</td><td></td><td>0/0</td></tr><tr><td></td><td>3-21-2</td><td>-1/-1</td><td>(11608,11627)</td><td>p,w,K*</td><td>−1,1,0/−1,−1,−2 2,1,0/2, -1, -2</td></tr><tr><td></td><td>１0</td><td>0/-2</td><td>(11729,11748)</td><td>p,w,</td><td></td></tr><tr><td></td><td>1-2</td><td>1/-3</td><td>(11841,11864)</td><td>,K*</td><td>2,0/-2,-2</td></tr><tr><td></td><td>2 1</td><td>0/0</td><td>(11626,11646,11665)</td><td>p,w</td><td>-2,2/-2,-2 2,2/2,-2</td></tr><tr><td>三b</td><td>0 3-2:</td><td>1/-1</td><td>(11748,11768,11767,11786)</td><td>p,w,K*</td><td>4,2/4,-2 −1,1,0/-1, −1, −2</td></tr><tr><td>/</td><td>1-2</td><td></td><td></td><td></td><td>2,1,0/2,−1,-2</td></tr><tr><td>)=/= （*） (0)</td><td>0</td><td>2/-2</td><td>(11859,11879,11883,11903)</td><td>K*</td><td>0/-4</td></tr><tr><td></td><td>1</td><td>0/-2</td><td>(11870,11889,11908)</td><td>p,w,</td><td>,1/,,1</td></tr><tr><td></td><td>0</td><td></td><td></td><td></td><td>,1/，</td></tr><tr><td>（/</td><td>1</td><td>1/-3</td><td>(11981,12000,12005,12024)</td><td>,K*</td><td>2,0/-2,-2</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>0</td><td>0/-4</td><td>(12092,12116,12140)</td><td>?</td><td>4/-4</td></tr></table></body></html>

TABLE X. The group theory factor $F ^ { \prime }$ , defined in Eq. (13), for the interaction of bottom-antibottom/bottom-bottom hadron pairs with only the light vector-meson exchanges. Here one of the bottom hadrons is an $s _ { \ell } = 3 / 2$ bottom meson. See the caption of Table VII.   

<html><body><table><tr><td>System</td><td>I</td><td>S</td><td>Thresholds [MeV]</td><td>Exchanged particles</td><td>F</td></tr><tr><td>B（）B1,2/B（）B1,2</td><td>0</td><td>0/0</td><td>(11005,11051,11018,11063)</td><td>p,W</td><td>1-2 2，</td></tr><tr><td></td><td>1</td><td>0/0</td><td></td><td></td><td>/</td></tr><tr><td>B（）Bs1,s2/B（*）Bs1,s2</td><td>1-2</td><td>1/-1</td><td>(11093,11141,11105,11154)</td><td></td><td>0/0</td></tr><tr><td>B）B1,2/B）B12</td><td>1-2</td><td>-1/1</td><td>(11108,11153,11119,11165)</td><td></td><td>0/0</td></tr><tr><td>B）Bs1,s2/B）B1,52</td><td>0</td><td>0/-2</td><td>(11196,11207,11244,11255)</td><td></td><td>1/-1</td></tr><tr><td>B1,2B1,2/B1,2B1,2</td><td>0</td><td>0/0</td><td>(11452,11464,11477)</td><td>p,w</td><td></td></tr><tr><td rowspan="2">Bs1,s2B1,2/Bs1,s2B1,2</td><td>1</td><td>1/1</td><td>(11555,11566,11567,11578)</td><td></td><td>1， 1-2 0/0</td></tr><tr><td>1-2 0</td><td></td><td></td><td></td><td></td></tr><tr><td>Bs1,s2Bs1,s2/Bs1,s2Bs1s A6B1,2/A6B1,2</td><td></td><td>0/-2</td><td>(11657,11669,11680)</td><td></td><td>1/1</td></tr><tr><td>AbBs1,s2/AbBs1,s2</td><td>1-2 0</td><td>0/0</td><td>(11346,11358)</td><td></td><td>-1/1</td></tr><tr><td>三6B1,2/三6B1,2</td><td></td><td>-1/1 -1/-1</td><td>(11448,11459) (11520,11533)</td><td>1</td><td>0/0</td></tr><tr><td></td><td>１０</td><td></td><td></td><td>p,w</td><td></td></tr><tr><td>三6Bs1,s2/三6Bs1,s2 B1,2/B12</td><td>1-2</td><td>-2/0</td><td>(11623,11634)</td><td></td><td>-1/1</td></tr><tr><td></td><td>3-21-2</td><td>0/0</td><td>(11539,11551,11559,11571)</td><td>p,W</td><td>−1,−1/−1,1 2,-1/2,1</td></tr><tr><td>)B1,2/)B1.2</td><td>1</td><td>1/-1</td><td>(11642,11653,11661,11672)</td><td></td><td>0/0</td></tr><tr><td></td><td>1</td><td>-1/-1</td><td>(11661,11673,11680,11692)</td><td>p,w</td><td>123-2 /</td></tr><tr><td>(B1.82/ B81.2</td><td>0</td><td></td><td></td><td></td><td>/</td></tr><tr><td></td><td>1-2</td><td>-2/0</td><td>(11764,11775,11783,11794)</td><td></td><td>-1/1</td></tr><tr><td>B12/0B12</td><td>1-2</td><td>-2/-2</td><td>(11772,11784,11796,11808)</td><td></td><td>0/0</td></tr><tr><td>）Bs12/0B1.82</td><td>0</td><td>-3/-1</td><td>(11875,11886,11899,11910)</td><td></td><td>-2/2</td></tr></table></body></html>